% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Hermite.r
\name{HermiteCov12}
\alias{HermiteCov12}
\title{Covariance matrix  for multivariate  T-Hermite polynomials}
\usage{
HermiteCov12(SigX12, N)
}
\arguments{
\item{SigX12}{Covariance matrix  of the Gaussian vectors X1 and X2 respectively
of dimensions d1 and  d2}

\item{N}{Common degree of the multivariate Hermite polynomials}
}
\value{
Covariance matrix of \eqn{H_N(X_1)} and \eqn{H_N(X_2)}
}
\description{
Computation of the covariance matrix between d-variate T-Hermite polynomials
\eqn{H_N(X_1)} and \eqn{H_N(X_2)}.
}
\examples{
Covmat<-matrix(c(1,0.8,0.8,1),2,2)
Cov_X1_X2 <- HermiteCov12(Covmat,3)

}
\references{
Gy.Terdik, Multivariate statistical methods - going beyond the linear,
Springer 2021. (4.59),  (4.66),
}
\seealso{
Other Hermite Polynomials: 
\code{\link{HermiteCoeff}()},
\code{\link{HermiteN}()},
\code{\link{HermiteN2X}()}
}
\concept{Hermite Polynomials}
