% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LHS_plot.R
\name{LHS_plot}
\alias{LHS_plot}
\title{Create 3D Scatter Plot for LHS Plant Ecological Strategy Data}
\usage{
LHS_plot(
  data,
  group = NULL,
  show_cube = TRUE,
  colors = c("#30123BFF", "#4777EFFF", "#1BD0D5FF", "#62FC6BFF", "#D2E935FF",
    "#FE9B2DFF", "#DB3A07FF", "#7A0403FF"),
  cube_angle = 60
)
}
\arguments{
\item{data}{A data frame containing LHS analysis results with the following required columns:
\describe{
\item{log_SLA}{Natural logarithm of specific leaf area}
\item{log_Height}{Natural logarithm of canopy height at maturity}
\item{log_SeedMass}{Natural logarithm of seed mass}
}
Typically this would be the output from the \code{LHS()} function. Row names should
represent species names or identifiers.}

\item{group}{Character string specifying the column name to use for grouping points by colour.
If \code{NULL} (default), all points will be plotted in the same colour. Common choices
include \code{"LHS_strategy"} to colour by the eight LHS strategy types (e.g., "S-S-S",
"L-L-L") or any other categorical variable in the dataset.}

\item{show_cube}{Logical indicating whether to display the 3D cube frame around the plot.
Default is \code{TRUE}, which helps with spatial orientation and depth perception.}

\item{colors}{Character vector of colours to use for different groups. Should contain at
least as many colours as there are levels in the grouping variable. Default provides
a viridis-inspired colour palette with 8 colours suitable for the 8 LHS strategy types.
If only one group is plotted, only the first colour will be used.}

\item{cube_angle}{Numeric value specifying the viewing angle for the 3D plot in degrees.
Default is 60. Values between 40-80 typically provide good visualisation perspectives.}
}
\value{
Invisibly returns the \code{scatterplot3d} object, which can be used for
adding additional graphical elements to the plot if needed.
}
\description{
The LHS scheme uses three fundamental plant traits that reflect important trade-offs
controlling plant ecological strategies :
\itemize{
\item \strong{Specific Leaf Area (SLA)}: Light-capturing area deployed per unit dry mass,
reflecting the trade-off between rapid resource acquisition and leaf longevity
\item \strong{Height}: Canopy height at maturity, expressing the amount of growth attempted
between disturbances and competitive ability for light
\item \strong{Seed Mass}: Reflecting the trade-off between seed number and individual seed
provisioning, affecting dispersal capacity and seedling survival
}

All three axes are log-scaled as they are approximately lognormally distributed between
species. The 3D visualisation allows researchers to explore species clustering
and relationships within the LHS strategy space, facilitating the identification of
functional groups and ecological patterns.
}
\details{
This function creates a three-dimensional scatter plot to visualise the LHS (Leaf-Height-Seed)
plant ecological strategy scheme proposed by Westoby (1998). The plot displays species positions
in the three-dimensional LHS space defined by log-transformed specific leaf area (SLA),
canopy height at maturity, and seed mass.

The function creates a 3D scatter plot using the \code{scatterplot3d} package, with
log-transformed trait values on each axis. When grouping is specified, the plot includes
an automated legend positioned to the right of the main plot area.

The three axes represent the core dimensions of the LHS ecological strategy space:
\itemize{
\item X-axis: log(SLA) - reflects the leaf economics spectrum from resource-conservative
to resource-acquisitive strategies
\item Y-axis: log(Height) - represents the plant size spectrum and competitive ability
for light capture
\item Z-axis: log(Seed Mass) - indicates the seed size spectrum affecting dispersal
and establishment success
}

The function automatically handles layout management when legends are displayed,
ensuring optimal use of plotting space.
}
\examples{
data(PFF)
pff <- PFF[, c("SLA", "Height", "SeedMass")]
rownames(pff) <- PFF$species
head(pff)
result <- LHS(pff)
head(result)
LHS_plot(result)
LHS_plot(result, group = "LHS_strategy", show_cube = TRUE)
}
\references{
\enumerate{
\item Westoby, M. (1998). A leaf-height-seed (LHS) plant ecology strategy scheme.
Plant and Soil, 199, 213–227.
\item Yang, J., Wang, Z., Zheng, Y., & Pan, Y. (2022). Shifts in plant ecological strategies
in remnant forest patches along urbanization gradients. Forest Ecology and Management, 524, 120540.
}
}
