% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/msmediate.R
\name{msmediate.concurrent}
\alias{msmediate.concurrent}
\title{Complex multisite causal mediation analysis with two concurrent mediators in the presence of complex sample and survey designs and non-random nonresponse}
\usage{
msmediate.concurrent(
  data,
  y,
  treatment,
  mediator,
  response,
  XR1,
  XR0,
  XM11,
  XM10,
  XM21,
  XM20,
  site,
  sample.weight
)
}
\arguments{
\item{data}{The data set for analysis.}

\item{y}{The name of the outcome variable (string).}

\item{treatment}{The name of the treatment variable (string).}

\item{mediator}{A vecor of two mediator variable names (string).}

\item{response}{The name of the response variable (string), which is equal to 1 if the individual responded and 0 otherwise.}

\item{XR1}{A vector of variable names (string) of pretreatment covariates in the propensity score model for the response under the treatment condition. For now, the multilevel propensity score model only allows for one random intercept.}

\item{XR0}{A vector of variable names (string) of pretreatment covariates in the propensity score model for the response under the control condition. For now, the multilevel propensity score model only allows for one random intercept.}

\item{XM11}{A vector of variable names (string) of pretreatment covariates in the propensity score model for the first mediator under the treatment condition. For now, the multilevel propensity score model only allows for one random intercept.}

\item{XM10}{A vector of variable names (string) of pretreatment covariates in the propensity score model for the first mediator under the control condition. For now, the multilevel propensity score model only allows for one random intercept.}

\item{XM21}{A vector of variable names (string) of pretreatment covariates in the propensity score model for the second mediator under the treatment condition. For now, the multilevel propensity score model only allows for one random intercept.}

\item{XM20}{A vector of variable names (string) of pretreatment covariates in the propensity score model for the second mediator under the control condition. For now, the multilevel propensity score model only allows for one random intercept.}

\item{site}{The variable name for the site ID (string).}

\item{sample.weight}{The variable name for the sample weight given by design (string).}
}
\value{
A list contains the estimates of the between-site variances of indirect effect via M1 given M2(0) ("I.M1(0)"), indirect effect via M2 given M1(1) ("I.M2(1)"), direct effect ("D"), indirect effect via M1 given M2(1) ("I.M1(1)"), indirect effect via M2 given M1(0) ("I.M2(0)"), interaction effect between M1 and M2 ("I.M1*M2"), and the correlations between the effects across sites ($Random_effects), and the population average effect estimates along with their hypothesis testing results ($Fixed_effects).
}
\description{
This function is used to estimate both the population average and between-site variance of a natural indirect transmitted through each mediator and a natural direct effect when two concurrent (conditionally independent) mediators are involved in the mediation mechanism. 
It incorporates a sample weight to adjust for complex sample and survey designs and employs an estimated nonresponse weight to account for non-random nonresponse.
}
\examples{
data(sim.weights)

msmediate.concurrent(data = sim.weights, y = "y", treatment = "tr", mediator = c("me",
    "me2"), response = "R", XR1 = c("x1", "x2", "x3"), XR0 = c("x1", "x2", "x3"),
    XM11 = c("x1", "x2", "x3"), XM10 = c("x1", "x2", "x3"), XM21 = c("x1", "x2",
        "x3"), XM20 = c("x1", "x2", "x3"), site = "site", sample.weight = "WD")

}
\references{
Qin, X., Deutsch, J, & Hong, G. (2021). Unpacking Complex Mediation Mechanisms and Their Heterogeneity between Sites in A Job Corps Evaluation. The Journal of Policy Analysis and Management, 40(1), 158-190. \doi{10.1002/pam.22268}
}
\author{
Xu Qin, Jonah Deutsch, and Guanglei Hong
}
