% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/My.stepwise.r
\name{My.stepwise.coxph}
\alias{My.stepwise.coxph}
\title{Stepwise Variable Selection Procedure for Cox's Proportional Hazards Model and Cox's Model}
\usage{
My.stepwise.coxph(Time = NULL, T1 = NULL, T2 = NULL, Status = NULL,
  variable.list, in.variable = "NULL", data, sle = 0.15, sls = 0.15,
  vif.threshold = 999)
}
\arguments{
\item{Time}{The 'Time' (time to an event) for the sepcified Cox's proportional hazards model as in coxph().}

\item{T1}{The 'T1' (Start) of the long-form data for the sepcified Cox's model as in coxph().}

\item{T2}{The 'T2' (Stop) of the long-form data for the sepcified Cox's model as in coxph().}

\item{Status}{The 'Status' (event indicator) for the sepcified Cox's proportional hazards model as in coxph().}

\item{variable.list}{A list of covariates to be selected.}

\item{in.variable}{A list of covariate(s) to be always included in the regression model.}

\item{data}{The data to be analyzed.}

\item{sle}{The chosen significance level for entry (SLE).}

\item{sls}{The chosen significance level for stay (SLS).}

\item{vif.threshold}{The chosen threshold value of variance inflating factor (VIF).}
}
\value{
A model object representing the identified "Stepwise Final Model" with the values of variance inflating factor (VIF) for all included covarites is displayed.
}
\description{
This stepwise variable selection procedure (with iterations between the 'forward' and 'backward' steps) can be applied to obtain the best candidate final Cox's proportional hazards model or Cox's proportional hazards model with time-dependent covariates (called the Cox's model).
}
\details{
The goal of regression analysis is to find one or a few parsimonious regression models that fit the observed data well for effect estimation and/or outcome prediction. To ensure a good quality of analysis, the model-fitting techniques for (1) variable selection, (2) goodness-of-fit assessment, and (3) regression diagnostics and remedies should be used in regression analysis. The stepwise variable selection procedure (with iterations between the 'forward' and 'backward' steps) is one of the best ways to obtaining the best candidate final regression model. All the bivariate significant and non-significant relevant covariates and some of their interaction terms (or moderators) are put on the 'variable list' to be selected. The significance levels for entry (SLE) and for stay (SLS) are suggested to be set at 0.15 or larger for being conservative. Then, with the aid of substantive knowledge, the best candidate final regression model is identified manually by dropping the covariates with p value > 0.05 one at a time until all regression coefficients are significantly different from 0 at the chosen alpha level of 0.05. Since the statistical testing at each step of the stepwise variable selection procedure is conditioning on the other covariates in the regression model, the multiple testing problem is not of concern. Any discrepancy between the results of bivariate analysis and regression analysis is likely due to the confounding effects of uncontrolled covariates in bivariate analysis or the masking effects of intermediate variables (or mediators) in regression analysis.
}
\section{Warning}{

The value of variance inflating factor (VIF) is bigger than 10 in continuous covariates or VIF is bigger than 2.5 in categorical covariates indicate the occurrence of multicollinearity problem among some of the covariates in the fitted regression model.
}

\examples{
\dontrun{
The data 'lung' is available in the 'survival' package.}

if (requireNamespace("survival", quietly = TRUE)) {
 lung <- survival::lung
}

names(lung)
dim(lung)
my.data <- na.omit(lung)
dim(my.data)
head(my.data)
my.data$status1 <- ifelse(my.data$status==2,1,0)
my.variable.list <- c("inst", "age", "sex", "ph.ecog", "ph.karno", "pat.karno")
My.stepwise.coxph(Time = "time", Status = "status1", variable.list = my.variable.list,
   in.variable = c("meal.cal", "wt.loss"), data = my.data)

my.variable.list <- c("inst", "age", "sex", "ph.ecog", "ph.karno", "pat.karno", "meal.cal",
   "wt.loss")
My.stepwise.coxph(Time = "time", Status = "status1", variable.list = my.variable.list,
   data = my.data, sle = 0.25, sls = 0.25)
}
\seealso{
\link{My.stepwise.lm}

\link{My.stepwise.glm}
}
