% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ATSmini.R
\name{ATSmini}
\alias{ATSmini}
\title{Kendall's tau and ATS line for censored data}
\usage{
ATSmini(y.var, y.cen, x.var)
}
\arguments{
\item{y.var}{The column of y (response variable) values plus detection limits.}

\item{y.cen}{The y-variable indicators, where 1 (or \code{TRUE}) indicates a detection limit in the \code{y.var} column, and 0 (or \code{FALSE}) indicates a detected value in \code{y.var}.}

\item{x.var}{The column of x (time for a trend test) values.}
}
\value{
Returns the intercept and slope (ATS line), tau (Kendall's tau), p-value and S-value (test statistic).
}
\description{
Computes Kendall's tau and the Akritas-Theil-Sen (ATS) line for censored data.  Is called by censeaken because it is much faster than the ATS function.  It is not expected to be of much use to users on its own. The x variable (time) may not be censored.
}
\examples{
\dontrun{
# x may not be censored.  Use the ATS function when x is censored.
data(Brumbaugh)

with(Brumbaugh, ATSmini(Hg, HgCen, SedLOI))
}
}
\references{
Akritas, M.G., Murphy, S.A., LaValley, M.P., 1995. The Theil-Sen Estimator With Doubly Censored Data and Applications to Astronomy. Journal of the American Statistical Association 90, 170–177. https://doi.org/10.2307/2291140

Helsel, D.R., 2011. Statistics for Censored Environmental Data using Minitab and R, 2nd ed. John Wiley & Sons, USA, N.J.
}
