% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parameters.R
\docType{data}
\name{parameters}
\alias{parameters}
\title{NAEP IRT parameters.}
\format{
A data frame with columns
\describe{
\item{source}{source of data, character}
\item{level}{grade or age level of test, integer}
\item{levelType}{"grade" or "age", character}
\item{NAEPid}{test item ID, character}
\item{assessmentCode}{"State" or "National", character}
\item{accommodations}{"accom" or "no-accom", character}
\item{subtest}{subtest within subject, character}
\item{subject}{subject of test, character}
\item{year}{year of test, integer}
\item{a}{slope or a parameter, numeric}
\item{b}{difficulty or d parameter, numeric}
\item{c}{guessing or g parameter, numeric}
\item{d1}{location of cut point 1 for polytomous item, numeric}
\item{d2}{location of cut point 2 for polytomous item, numeric}
\item{d3}{location of cut point 3 for polytomous item, numeric}
\item{d4}{location of cut point 4 for polytomous item, numeric}
\item{d5}{location of cut point 5 for polytomous item, numeric}
}
}
\usage{
parameters
}
\description{
This data table contains NCES NAEP Assessment IRT parameters from 1990 to 2015.
To find all item parameters for an assessment, filter the data table by level, subject,
and year. Assessments from 1990 to 2000 also require filtering by assessmentCode and
accommodations.
}
\examples{
\dontrun{

param <- NAEPirtparams::parameters
param8M2005 <- param[param$level == 8 & param$subject == 'Mathematics' & param$year == 2005, ]
head(param8M2005)
      source level levelType  NAEPid  ...  subtest     subject year    a     b    c  ...  
7657 website     8     grade M066201  ...  algebra Mathematics 2005 0.77 -1.75 0.07  ...  
7658 website     8     grade M067401  ...  algebra Mathematics 2005 0.92  1.28 0.18  ...  
7659 website     8     grade M086101  ...  algebra Mathematics 2005 0.63  0.32 0.11  ...  
7660 website     8     grade M047701  ...  algebra Mathematics 2005 1.01  1.29 0.26  ...  
7661 website     8     grade M067301  ...  algebra Mathematics 2005 1.02 -0.03 0.16  ...  
7662 website     8     grade M067701  ...  algebra Mathematics 2005 0.78 -2.01 0.06  ...  

}
}
\references{
Department of Education, Institute of Education Sciences, National Center for Education Statistics, National Assessment of Educational Progress (NAEP), 1990-2015, various subjects. Retrieved from \url{https://nces.ed.gov/nationsreportcard/tdw/analysis/scaling_irt.aspx}
}
\keyword{datasets}
