% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nmmipw.R
\name{summary.NMMIPW}
\alias{summary.NMMIPW}
\alias{print.summary.NMMIPW}
\title{Summarizing IPW or AIPW Estimators under Nonmonotone Missing at Random Data}
\usage{
\method{summary}{NMMIPW}(object, ...)

\method{print}{summary.NMMIPW}(x, ...)
}
\arguments{
\item{object}{an object of class "NMMIPW", usually, a result of a call to NMMIPW.}

\item{...}{further arguments passed to or from other methods.}

\item{x}{an object of class "summary.NMMIPW", usually, a result of a call to summary.NMMIPW.}
}
\value{
The function summary.NMMIPW computes and returns a list of summary statistics of the fitted model given in object.
}
\description{
summary method for class "NMMIPW".
}
\details{
print.summary.NMMIPW tries to be smart about formatting coefficients, an estimated variance covariance matrix of
the coefficients, Z-values and the corresponding P-values.
}
\examples{
n = 100
X = rnorm(n, 0, 1)
Y = rnorm(n, 1 * X, 1)
O1 = rbinom(n, 1, 1/(1 + exp(-1 - 0.5 * X)))
O2 = rbinom(n, 1, 1/(1 + exp(+0.5 + 1 * Y)))
O = cbind(O1, O2)
df <- data.frame(Y = Y, X = X)
fit <- nmm_fit(data = df, O = O, formula = Y ~ X, funct = lm)
summary(fit)
}
