% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NMreadParsText.R
\name{NMreadParsText}
\alias{NMreadParsText}
\title{Read comments to parameter definitions in Nonmem control streams}
\usage{
NMreadParsText(
  file,
  lines,
  format,
  format.omega = format,
  format.sigma = format.omega,
  spaces.split = FALSE,
  unique.matches = TRUE,
  field.idx = "idx",
  use.idx = FALSE,
  add.init = TRUE,
  modelname,
  col.model,
  as.fun,
  use.theta.idx,
  fields,
  fields.omega = fields,
  fields.sigma = fields.omega
)
}
\arguments{
\item{file}{Path to the control stream to read.}

\item{lines}{As an alternative to `file`, the control stream or
selected lines of the control stream can be provided as a
vector of lines.}

\item{format}{Defines naming and splitting of contents of lines in
parameter sections. Default is
\code{"\%init;\%idx;\%symbol;\%label;\%unit"}. Be careful to
remember percentage symbols in front of any variable names.}

\item{format.omega}{Like `format`, applied to `$OMEGA`
section. Default is to reuse `format`.}

\item{format.sigma}{Like `format`, applied to `$SIGMA`
section. Default is to reuse `format.omega`.}

\item{spaces.split}{Is a blank in `fields` to be treated as a
field separator? Default is not to (i.e. neglect spaces in
`fields`).}

\item{unique.matches}{If TRUE, each line in the control stream is
assigned to one parameter, at most. This means, if two
parameters are listed in one line, the comments will only be
used for one of the parameters, and only that parameter will
be kept in output. Where this will typically happen is in
`$OMEGA` and `$SIGMA` sections where off-diagonal may be put
on the same line as diagonal elements. Since the off-diagonal
elements are covariances of variables that have already been
identified by the diagonals, the off-diagonal elements can be
automatically described. For example, if `OMEGA(1,1)` is
between-subject variability (BSV) on CL and `OMEGA(2,2) is BSV
on V, then we know that `OMEGA(2,1)` is covariance of (BSV on)
CL and V.}

\item{field.idx}{If an index field is manually provided in the
control stream comments, define the name of that field in
`format` and tell `NMreadParsText()` to use this idx to
organize especially OMEGA and SIGMA elements by pointing to it
with `field.idx`. The default is to look for a variable called
`idx`. If the index has values like 1-2 on an OMEGA or SIGMA
row, the row is interpreted as the covariance between
OMEGA/SIGMA 1 and 2.}

\item{use.idx}{The default method is to automatically identify
element numbering (`i` for THETAs, `i` and `j` for OMEGAs and
SIGMAs). The automated method is based on identification of
`BLOCK()` structures and numbers of initial values. Should
this fail, or should you want to control this manually, you
can include a parameter counter in the comments and have
`NMreadParsText()` use that to assign the
numbering. `use.idx=FALSE` is default and means all blocks are
handled automatically, `use.idx=TRUE` assumes you have a
counter in all sections, and a character vector like
`use.idx="omega"` can be used to denote which sections use
such a counter from the control stream. When using a counter
on OMEGA and SIGMA, off-diagonal elements MUST be denoted by
`i-j`, like `2-1` for OMEGA(2,1). See `field.idx` too.}

\item{add.init}{If `TRUE` (default), a field will automatically be
added to the formats for the initial value string. This will
be called "initstr". It will only happen if the first field is
not called either "initstr" or "init". The only situation
where one would use `add.init=FALSE` is if a different name
for the initial value field is already included in formats.}

\item{modelname}{See ?NMscanData}

\item{col.model}{See ?NMscanData}

\item{as.fun}{See ?NMscanData}

\item{use.theta.idx}{If an index field in comments should be used
to number thetas. The index field is used to organize
`$OMEGA`s and `$SIGMA`s because they are matrices but I do not
see where this is advantageous to do for `$THETA`s. Default
`use.theta.idx=FALSE` which means `$THETA`s are simply
counted.}

\item{fields}{Deprecated. Use `format`.}

\item{fields.omega}{Deprecated. Use `format.omega`.}

\item{fields.sigma}{Deprecated. Use `format.sigma`.}
}
\value{
data.frame with parameter names and fields read from
    comments
}
\description{
When interpreting parameter estimates, it is often needed to
recover information about the meaning of the different parameters
from control stream. `NMreadParsText` provides a flexible way to
organize the comments in the parameter sections into a
`data.frame`. This can subsequently easily be merged with parameter
values as obtained with `NMreadExt`.
}
\details{
Off-diagonal omega and sigma elements will only be
    correctly treated if their num field specifies say 1-2 to
    specify it is covariance between 1 and 2.

\code{SAME} elements in \code{$OMEGA} will be skipped altogether.
}
\examples{

## setDTthreads() is only needed for CRAN. Users should not do this.
data.table::setDTthreads(1)
## end setDTthreads() for CRAN

## notice, examples on explicitly stated lines. Most often in
## practice, one would use the file argument to automatically
## extract the $THETA, $OMEGA and $SIGMA sections from a control
## stream.

text <- c("

$THETA  (.1)             ;[1]; LTVKA (mL/h)
$OMEGA  BLOCK(3)
0.126303  ;    IIV.CL  ; 1   ;IIV     ;Between-subject variability on CL;-
0.024  ; IIV.CL.V2.cov  ; 1-2 ;IIV     ;Covariance of BSV on CL and V2;-
0.127  ;    IIV.V2  ; 2   ;IIV     ;Between-subject variability on V2;-
0.2  ; IIV.CL.V3.cov  ; 1-3 ;IIV     ;Covariance of BSV on CL and V3;-
0.2  ; IIV.V2.V3.cov  ; 2-3 ;IIV     ;Covariance of BSV on V2 and V3;-
0.38  ;    IIV.V3  ; 3   ;IIV     ;Between-subject variability on V3;-
$OMEGA 0 FIX ; IIV.KA ; 4  ;IIV     ;Between-subject variability on KA;-
$SIGMA 1
")
   lines <- strsplit(text,split="\n")[[1]]

res <- NMreadParsText(lines=lines,
format="\%init;[\%num];\%symbol",
format.omega="\%init; \%symbol ; \%num ; \%type   ; \%label ; \%unit",
field.idx="num")

## BLOCK() SAME are skipped
text <- c("
$THETA
(0,0.1) ; THE1      - 1) 1st theta
(0,4.2) ; THE2        - 2) 2nd theta
$OMEGA  0.08   ;    IIV.TH1  ; 1  ;IIV
$OMEGA  BLOCK(1)
0.547465  ; IOV.TH1  ; 2 ;IOV
$OMEGA  BLOCK(1) SAME
$OMEGA  BLOCK(1) SAME")
lines <- strsplit(text,split="\n")[[1]]
res <- NMreadParsText(lines=lines,
                         format="\%init;\%symbol - \%idx) \%label",
                         format.omega="\%init; \%symbol  ; \%idx  ; \%label "
                         )
}
