% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NPBBBD_Aeff.R
\name{NPBBBD_Aeff}
\alias{NPBBBD_Aeff}
\title{A-Efficiency for Nested Partially Balanced Bipartite Block (NPBBB) Designs}
\usage{
NPBBBD_Aeff(bd, sbd, v1, v2)
}
\arguments{
\item{bd}{Block design (ignoring sub-blocks) in matrix form considering rows as blocks}

\item{sbd}{Sub-block design (ignoring blocks) in matrix form considering rows as blocks}

\item{v1}{Number of test treatments}

\item{v2}{Number of control treatments}
}
\value{
The output includes:
\itemize{
  \item \code{v1}: Number of test treatments
  \item \code{v2}: Number of controls
  \item \code{b1}: Number of blocks
  \item \code{b2}: Number of sub-blocks
  \item \code{r1}: Test replications
  \item \code{r2}: Control replications
  \item \code{k1}: Block size
  \item \code{k2}: Sub-block size
  \item \code{Lambdas1}: Lambda values from block design
  \item \code{Lambdas2}: Lambda values from sub-block design
  \item \code{E1}: Block design efficiency
  \item \code{E2}: Sub-block design efficiency
}
}
\description{
This function calculates the A-efficiency values for the block and sub-block structures of a given NPBBB design
}
\examples{
## Not run:
library(NPBBBDAefficiency)
NPBBBD_Aeff(matrix(c(1, 2, 3, 4), nrow = 2, byrow = TRUE),
            matrix(c(1, 2, 3, 4), nrow = 2, byrow = TRUE),
            v1 = 2, v2 = 2)
## End(Not run)
}
\references{
Vinayaka, Parsad R, Mandal BN, Dash S, LN Vinaykumar, Kumar M, Singh DR (2023) <doi:10.1080/03610926.2023.2251623>
}
