% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nasdaq_data_link_pointintime.R
\name{NasdaqDataLink.pit.fromto}
\alias{NasdaqDataLink.pit.fromto}
\title{Retrieves Point In Time Data from the Nasdaq Data Link PIT endpoint.
From start to end will also show all rows that were visible at any point between two specified points in time, including start, but excluding end.}
\usage{
NasdaqDataLink.pit.fromto(
  datatable_code,
  start_date,
  end_date,
  paginate = FALSE,
  ...
)
}
\arguments{
\item{datatable_code}{Datatable code on Nasdaq Data Link specified as a string.}

\item{start_date}{Lower date as a string.}

\item{end_date}{Upper date as a string.}

\item{paginate}{When set to TRUE, fetches up to 1,000,000 rows of data}

\item{...}{Additional named values that are interpreted as Nasdaq Data Link API parameters.}
}
\value{
Returns a data.frame.
}
\description{
Retrieves Point In Time Data from the Nasdaq Data Link PIT endpoint.
From start to end will also show all rows that were visible at any point between two specified points in time, including start, but excluding end.
}
\details{
Set your \code{api_key} with \code{NasdaqDataLink.api_key} function. For instructions on finding your api key go to \url{https://data.nasdaq.com/account/profile}
}
\examples{
\dontrun{
NasdaqDataLink.pit.fromto('RSM/MSB', '2020-06-11', '2020-06-12', paginate=TRUE)
}
}
\seealso{
\code{\link{NasdaqDataLink.api_key}}
}
