% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nasdaq_data_link_api.R
\name{nasdaq_data_link.api}
\alias{nasdaq_data_link.api}
\title{Executes Nasdaq Data Link API calls}
\usage{
nasdaq_data_link.api(
  path,
  http = c("GET", "PUT", "POST", "DELETE"),
  postdata = NULL,
  ...
)
}
\arguments{
\item{path}{Path to api resource.}

\item{http}{Type of http request sent.}

\item{postdata}{A character or raw vector that is sent in a body.}

\item{...}{Named values that are interpretted as Nasdaq Data Link API parameters. Please see \url{https://docs.data.nasdaq.com/}.}
}
\value{
Nasdaq Data Link API response.
}
\description{
Executes Nasdaq Data Link API calls
}
\details{
Set your \code{api_key} with \code{NasdaqDataLink.api_key} function. For instructions on finding your api key go to \url{https://data.nasdaq.com/account/profile}
}
\examples{
\dontrun{
data_link_data = nasdaq_data_link.api(path="datasets/NSE/OIL", http="GET")
plot(data_link_data[,1])
}
}
\seealso{
\code{\link{NasdaqDataLink.api_key}}
}
