% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NatParksPalettes.R
\name{natparks.pals}
\alias{natparks.pals}
\title{National Parks Palette Generator}
\usage{
natparks.pals(
  name,
  n,
  type = c("discrete", "continuous"),
  direction = c(1, -1),
  override.order = FALSE
)
}
\arguments{
\item{name}{Name of Palette. Choices are:
\code{Acadia}, \code{Arches}, \code{Arches2}, \code{Banff}, \code{Bryce Canyon},
\code{DeathValley}, \code{Everglades}, \code{Glacier}, \code{GrandCanyon}, \code{KingsCanyon},
\code{Olympic}, \code{Redwood}, \code{SmokyMtns}, \code{Yellowstone}, and \code{Yosemite}.}

\item{n}{Number of desired colors. If number of requested colors is beyond the scope of the palette,
colors are automatically interpolated. If n is not provided, the length of the palette is used.}

\item{type}{Either "continuous" or "discrete". Use continuous if you want to automatically
interpolate between colors.}

\item{direction}{Sets order of colors. Default palette is 1. If direction is -1, palette color order is reversed}

\item{override.order}{Colors are picked from palette to maximize readability and aesthetics. This means
that colors are not always selected in sequential order from the full palette. If override.order is set to TRUE,
colors are selected in sequential order from the full palette instead. Default is FALSE.}
}
\value{
A vector of colors.
}
\description{
Color palettes inspired by National Parks. Complete list of palette colors and the parks that 
inspired them can be found \href{https://github.com/kevinsblake/NatParksPalettes}{on Github}.
Use \code{\link{colorblind.friendly}} to check whether palettes are colorblind-friendly.
}
\examples{
natparks.pals("Yellowstone")

natparks.pals("Glacier", direction=-1)

natparks.pals("DeathValley", 4, override.order=TRUE)

library(ggplot2)
ggplot(data=iris, aes(x=Species, y=Petal.Length, fill=Species)) +
geom_violin() +
scale_fill_manual(values=natparks.pals("Yellowstone", 3))

ggplot(data=iris, aes(x=Sepal.Length, y=Sepal.Width, color=Species)) +
geom_point(size=2) +
scale_color_manual(values=natparks.pals("Banff", 3))

ggplot(data=iris, aes(x=Species, y=Sepal.Width, color=Sepal.Width)) +
geom_point(size=3) +
scale_color_gradientn(colors=natparks.pals("Arches2"))
}
\keyword{colors}
