% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nd_nfd.R
\name{nd.nfd}
\alias{nd.nfd}
\title{Network Flow Distance}
\usage{
nd.nfd(
  A,
  order = 0,
  out.dist = TRUE,
  vect = seq(from = 0, to = 10, length.out = 1000)
)
}
\arguments{
\item{A}{a list of length \eqn{N} containing adjacency matrices.}

\item{order}{the order of Laplacian; currently only 0 and 1 are supported.}

\item{out.dist}{a logical; \code{TRUE} for computed distance matrix as a \code{dist} object.}

\item{vect}{a vector of parameters \eqn{t} whose values will be used.}
}
\value{
a named list containing \describe{
\item{D}{an \eqn{(N\times N)} matrix or \code{dist} object containing pairwise distance measures.}
}
}
\description{
Network Flow Distance
}
\examples{
\dontrun{
## load example data
data(graph20)

# compute two diffusion-based distances and visualize
out1 = nd.gdd(graph20, out.dist=FALSE)
out2 = nd.nfd(graph20, out.dist=FALSE)

# visualize
opar <- par(no.readonly=TRUE)
par(mfrow=c(1,2), pty="s")
image(out1$D[,20:1],col=gray((0:32)/32), main="nd.gdd",axes=FALSE)
image(out2$D[,20:1],col=gray((0:32)/32), main="nd.nfd",axes=FALSE)
par(opar)
}

}
