% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dCor.R
\name{dCor}
\alias{dCor}
\title{Distance Correlation for ROI Time Series}
\usage{
dCor(neurallist, centering = c("U", "double"))
}
\arguments{
\item{neurallist}{List.
A time series list from \code{\link[NetworkToolbox]{convertConnBrainMat}} function}

\item{centering}{Character.
Options for centering the Euclidean distances.

\itemize{
\item \code{"U"} --- Uses number of time points minus 2 in the computation of the mean

\item \code{"double"} --- Uses the mean

}}
}
\value{
Returns a \emph{m} x \emph{m} matrix corresponding to distance correlations
between ROIs
}
\description{
Computes the distance correlation (Yoo et al., 2019) for
ROI time series data. This function is mainly a subroutine for the
\code{\link[NetworkToolbox]{dCor.parallel}} function
}
\examples{
\dontrun{
# Import time series data
neurallist <- convertConnBrainMat()

# Run distance correlation
dCor(neurallist)

}

}
\references{
Yoo, K., Rosenberg, M. D., Noble, S., Scheinost, D., Constable, R. T., & Chun, M. M. (2019).
Multivariate approaches improve the reliability and validity of functional connectivity and prediction of individual behaviors.
\emph{NeuroImage}, \emph{197}, 212-223.
}
\author{
Alexander Christensen <alexpaulchristensen@gmail.com>
}
