% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core.R
\name{posteriormode}
\alias{posteriormode}
\title{posteriormode}
\usage{
posteriormode(estimator, Z, ...)
}
\arguments{
\item{estimator}{a neural posterior or likelihood-to-evidence-ratio estimator}

\item{Z}{data in a format amenable to the neural-network architecture of \code{estimator}}

\item{...}{additional keyword arguments passed to the Julia version of \href{https://msainsburydale.github.io/NeuralEstimators.jl/dev/API/core/#NeuralEstimators.posteriormode}{\code{posteriormode()}}}
}
\value{
a d × K matrix of posterior samples, where d is the dimension of the parameter vector and K is the number of data sets provided in \code{Z}
}
\description{
Computes the (approximate) posterior mode (maximum a posteriori estimate) given data \code{Z}.
}
\seealso{
\code{\link[=sampleposterior]{sampleposterior()}} for sampling from the approximate posterior distribution
}
