% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-documentation.R
\name{AD_biomarkers_tbl_df}
\alias{AD_biomarkers_tbl_df}
\title{Alzheimer's Biomarkers}
\format{
A tibble with 333 observations and 131 variables:
\describe{
  \item{age}{Numeric: Patient age}
  \item{male}{Numeric: Indicator for male gender (1 = male, 0 = female)}
  \item{Genotype}{Factor: Apolipoprotein E genotype}
  \item{Class}{Factor: Clinical classification (e.g., healthy, impaired)}
  \item{Ab_42}{Numeric: Amyloid-beta 42 protein measurement}
  \item{tau}{Numeric: Tau protein measurement}
  \item{p_tau}{Numeric: Phosphorylated Tau protein measurement}
  \item{[131 additional biomarker variables]}{Numeric measurements of various proteins and biomarkers}
}
}
\source{
Data taken from the modeldata package version 1.4.0. Original study:
Craig-Schapiro R, Kuhn M, Xiong C, et al. (2011) Multiplexed Immunoassay Panel Identifies
Novel CSF Biomarkers for Alzheimer's Disease Diagnosis and Prognosis. PLoS ONE 6(4): e18850.
}
\usage{
data(AD_biomarkers_tbl_df)
}
\description{
This dataset, AD_biomarkers_tbl_df, is a tibble containing clinical data
from 333 patients in a study of Alzheimer's disease biomarkers. The study included
patients with mild cognitive impairment and healthy controls, with measurements
of demographic characteristics, apolipoprotein E genotype, protein biomarkers
(including Abeta, Tau, and pTau), and clinical dementia scores.
}
\details{
The dataset name has been kept as 'AD_biomarkers_tbl_df' to avoid confusion
with other datasets in the R ecosystem. This naming convention helps distinguish
this dataset as part of the NeuroDataSets package. The suffix 'tbl_df' indicates
that the dataset is a tibble. The original content has not been modified.
}
