% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pseudo.present.points.R
\name{pseudo.present.points}
\alias{pseudo.present.points}
\title{Generation of pseudo present points for niche model building}
\usage{
pseudo.present.points(
  data,
  outputNum = 50,
  lonRange = 2,
  latRange = 1,
  en.vir = NULL,
  map = TRUE
)
}
\arguments{
\item{data}{Data frame, longitude and latitude of a single species.}

\item{outputNum}{Numeric, the expected number of points.}

\item{lonRange}{Range of the longitude of the points generated.}

\item{latRange}{Range of the latitude of the points generated.}

\item{en.vir}{RasterBrick, the globle bioclimate data obtained from
"raster::getData" function.}

\item{map}{Logical. Should a map be drawn?}
}
\value{
A data frame, containing actual present points and simulated pseudo
points.
}
\description{
Randomly generate pseudo points around actual present
distribution site when the number of present points is inadequate for
building a niche model.
}
\examples{
data(en.vir)
#envir<-raster::getData("worldclim",download=FALSE,var="bio",res=2.5)
#en.vir<-raster::brick(envir)

data<-data.frame(species=rep("Acosmeryx anceus",3),
                 Lon=c(145.380,145.270,135.461),
                 Lat=c(-16.4800,-5.2500,-16.0810))


present.points<-pseudo.present.points(data,10,2,1,en.vir=en.vir)
present.points
}
\author{
Cai-qing YANG (Email: yangcq_ivy(at)163.com) and Ai-bing ZHANG
(Email:zhangab2008(at)cnu.edu.cn), Capital Normal University (CNU), Beijing,
CHINA.
}
\keyword{pseudo.present.points}
