\name{ecodata}
\alias{ecodata}
\title{Ecological data set to exemplify the use of the functions contained in \emph{NonParRolCor} 
}
\description{
The data set \code{\link{ecodata}} contains four columns, the first one (named ``Years'') is the time (years from 1989 to 2008, monthly resolution), the second (named ``SST'') are monthly anomalies of sea surface temperature (SST) of the south of Gran Canaria (28.5 N/16.5 W) (NOAA 2021a), the third column (named ``NAO'') are the monthly index of the North Atlantic Oscillation (NAO) (NOAA 2021b), and the last column (named ``CPUE'') are monthly catches of common octopus (measured as CPUE or Catch Per Unit of Effort) from an artisanal fisheries from the Southwest of Gran Canaria Islands (Caballero-Alfonso et al. 2010, Polanco et al. 2011, Polanco-Martínez 2012). 
}
\usage{data(ecodata)
}
\format{One file in ASCII format containing four columns and 240 rows, columns are separated by spaces. 
}
\source{
Caballero-Alfonso, A, Ganzedo, U., Trujillo-Santana, A., Polanco, J., del Pino, A. S., Ibarra-Berastegi, G., Castro-Hernández, J. (2010). The role of climatic variability on the short-term fluctuations of octopus captures at the Canary Islands. Fisheries Research, 102(3), 258-265. <URL: \doi{10.1016/j.fishres.2009.12.006}>. \cr

NOAA Optimum Interpolation (OI) Sea Surface Temperature (SST) V2, <URL: \url{https://psl.noaa.gov/data/gridded/data.noaa.oisst.v2.html}>, accessed: 2021-02-28. \cr

NAO index, <URL: \url{https://psl.noaa.gov/data/correlation/nao.data}>, accessed: 2021-02-28. \cr

Polanco, J., Ganzedo, U., Sáenz, J., Caballero-Alfonso, A. M., & Castro-Hernández, J. J. (2011). Wavelet analysis of correlation among Canary Islands octopus captures per unit effort, sea-surface temperatures and the North Atlantic Oscillation. Fisheries Research, 107(1-3), 177-183. <URL: \doi{10.1016/j.fishres.2010.10.019}>. \cr

Polanco-Martínez, J.M. (2012). Aplicación de técnicas estadísticas en el estudio de fenómenos ambientales y ecosistémicos, Ph.D. thesis, University of Basque Country, Spain. <URL: \url{https://addi.ehu.es/handle/10810/11295/}>. 
}
\keyword{ecological_dataset}

