% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Hu_Chen_Unit_Root.R
\name{Hu_Chen_Unit_Root}
\alias{Hu_Chen_Unit_Root}
\title{Hu and Chen(2016) nonlinear unit root test function}
\usage{
Hu_Chen_Unit_Root(x, case, lags, lsm)
}
\arguments{
\item{x}{series name,}

\item{case}{if raw data 1 if demeaned data 2 if detrended data 3,}

\item{lags}{maximum lag}

\item{lsm}{lag selection methods if 1 AIC, if 2 BIC, if 3 t-stat significance}
}
\value{
"Model" Estimated model

"Selected lag" the lag order

"Test Statistic" the value of the test statistic
}
\description{
This function allows you to make Hu and Chen(2016) nonlinear unit root test
}
\examples{

x <- rnorm(1000)
Hu_Chen_Unit_Root(x, case = 1, lags = 6, lsm = 3)

y <- cumsum(rnorm(1000))
Hu_Chen_Unit_Root(y, 1, 3, 2)

data(IBM)
Hu_Chen_Unit_Root(IBM, case = 2,lags = 12, lsm = 2)


}
\references{
Hu, J., & Chen, Z. (2016). A unit root test against globally stationary ESTAR models when local condition is non-stationary. Economics letters, 146, 89-94.



Burak Guris, R Uygulamalı Dogrusal Olmayan Zaman Serileri Analizi, DER Yayinevi, 2020.
}
\keyword{nonlinear}
\keyword{root}
\keyword{test}
\keyword{unit}
