% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OLStraj.R
\name{OLStraj}
\alias{OLStraj}
\title{OLStraj}
\usage{
OLStraj(
  data,
  idvarname = "id",
  predvarname = "time",
  outvarname = "score",
  varlist = c("anti1", "anti2", "anti3", "anti4"),
  timepts = c(0, 1, 2, 3),
  inclmiss = FALSE,
  level = "both",
  regtype = "lin",
  numplot = NULL,
  hist = TRUE,
  int_bins = 30,
  lin_bins = 30,
  quad_bins = 30,
  box = TRUE,
  outds = TRUE,
  ...
)
}
\arguments{
\item{data}{A data frame}

\item{idvarname}{A quoted variable name identifying the column in data which
serves as the case identifier}

\item{predvarname}{A quoted predictor variable label.}

\item{outvarname}{A quoted outcome variable label.}

\item{varlist}{A vector of quoted variable names found in data}

\item{timepts}{A vector specifying how time points should be coded}

\item{inclmiss}{A logical specifying whether or not to use complete cases.
Set inclmiss to FALSE in order to filter data down to complete cases.}

\item{level}{Control which OLS trajectory plots to show.  If level is set to
"grp" then only group level plots will be shown, if level is set to "ind" then
only individual level plots will be shown, and if level is set to "both" then
both group and individual level plots will be shown.}

\item{regtype}{Set regtype to "quad" to include quadratic term in the cbc_lm
call or set regtype to "lin" to exclude the quadratic term.  Use regtype = "both"
to include the quadratic term in the cbc_lm call and to include both linear
and quadratic terms on the individual OLS-estimated trajectory plots.}

\item{numplot}{Specify an integer to subset the number of cases used in OLStraj}

\item{hist}{Set hist to  TRUE to include histograms or FALSE to exclude}

\item{int_bins}{Set the number of bins for the intercept term's histogram}

\item{lin_bins}{Set the number of bins for the linear term's histogram}

\item{quad_bins}{Set the number of bins for the quadratic term's histogram}

\item{box}{Set box to TRUE to include boxplots or FALSE to exclude}

\item{outds}{Set outds to TRUE to include the output as a data frame.  Output
will contain original data used in the OLStraj algorithm with the parameter
estimates obtained from cbc_lm}

\item{...}{Pass additional arguments to cbc_lm}
}
\value{
A list containing an output data frame (if outds is set to TRUE), the
selected plots, and the case-by-case regression model object.
}
\description{
Implements the OLS trajectory analysis method as detailed in Carrig et al (2004).
The method uses case-by-case ordinary least squares (OLS) regression to estimate
individual growth curves over time. The function provides options for
group-level and individual-level plots and accommodates linear and quadratic
models.
}
\examples{
  df <- data.frame(id = c(1,2,3,4,5),
                   var1 = c(3,7,4,5,8),
                   var2 = c(7,3,9,4,7),
                   var3 = c(8,5,3,9,7),
                   var4 = c(1,5,3,9,30))

  olstraj_out <- OLStraj(data = df,
                         varlist = c("var1", "var2", "var3", "var4"),
                         regtype = "quad",
                         int_bins = 5,
                         lin_bins = 5,
                         quad_bins = 5)
}
\references{
Carrig, M.M., Wirth, R.J., & Curran, P.J. (2004). A SAS Macro for Estimating
and Visualizing Individual Growth Curves.  Structural Equation Modeling: A
Multidisciplinary Journal, 11(1), 132-149.
\doi{10.1207/S15328007SEM1101_9}
}
