% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.R
\name{summary.PredictionMap}
\alias{summary.PredictionMap}
\title{Summary of prediction maps}
\usage{
\method{summary}{PredictionMap}(object = NULL, ...)
}
\arguments{
\item{object}{A PredictionMap object as it is returned by \code{\link{predictionMap}}-function.}

\item{...}{Further arguments passed from other methods.}
}
\description{
\code{summary.PredictionMap} returns a summarizing overview of a PredictionMap object.
}
\details{
This function gives an overview of the PredictionMap object. 
A short summary about the utilized data and labels is given as well as the number of runs and folds of the cross-validation.
The summary also includes if the prediction map was generated in parallel and the name of the utilized TunePareto classifier as well as its specified parameters.
}
\examples{
library(TunePareto)
data(esl)
data = esl$data
labels = esl$labels
foldList = generateCVRuns(labels  = labels,
                          ntimes      = 2,
                          nfold       = 2,
                          leaveOneOut = FALSE,
                          stratified  = TRUE)
predMap = predictionMap(data, labels, foldList = foldList, 
                       classifier = tunePareto.svm(), kernel='linear')

summary(predMap)
}
\seealso{
\code{\link{predictionMap}}, \code{\link{summary.Subcascades}}, \code{\link{summary.Groupwise}}, \code{\link{summary.Conf}}, \code{\link{summary.ConfusionTable}}
}
