% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OSCV_density.R
\name{OSCV_Gauss_dens}
\alias{OSCV_Gauss_dens}
\title{The OSCV function based on \eqn{L_G}, the one-sided Gaussian kernel, in the kernel density estimation (KDE) context.}
\usage{
OSCV_Gauss_dens(h, dat, stype)
}
\arguments{
\item{h}{numerical vector of bandwidth values,}

\item{dat}{numerical vecror of data values,}

\item{stype}{specifies (anticipated) smoothness of the density function. Thus, \eqn{stype=0} corresponds to the \emph{smooth} density, whereas \eqn{stype=1} corresponds to the \emph{nonsmooth} density.}
}
\value{
The vector of values of the OSCV function for the correponsing vector of \eqn{h} values.
}
\description{
Computing the values of the \eqn{L_G}-based OSCV function in the density estimation context. See Savchuk (2017).
}
\details{
Computing the values of the OSCV function for the given bandwidth vector \eqn{h} and data vector \eqn{dat}. The function is based on the one-sided Gaussian kernel \eqn{L_G}. The (anticipated) smoothness of the underlying density function is to be specified. Thus, \itemize{\item \eqn{stype=0} corresponds to the smooth density; \item \eqn{stype=1} corresponds to the nonsmooth density.} It is usually assumed that the density is smooth if no preliminary information about its nonsmoothness is available. The function's minimizer \code{\link{h_OSCV_dens}} is to be used without additional rescaling to compute the ultimate Gaussian density estimate.
}
\examples{
\dontrun{
dat_norm=rnorm(300)   #generating random sample of size n=300 from the standard normal density.
h_oscv=round(h_OSCV_dens(dat_norm,0),digits=4)
y=density(dat_norm,bw=h_oscv)
dev.new()
plot(y,lwd=3,cex.lab=1.7,cex.axis=1.7,cex.main=1.7,xlab=paste("n=100, h_OSCV=",h_oscv),
main="Standard normal density estimate by OSCV",ylim=c(0,0.45),xlim=c(-4.5,4.5))
u=seq(-5,5,len=1000)
lines(u,dnorm(u),lwd=3,lty="dashed",col="blue")
legend(0.75,0.4,legend=c("OSCV estimate","N(0,1) density"),lwd=c(3,3),lty=c("solid","dashed"),
col=c("black","blue"),bty="n",cex=1.25)
}
}
\references{
Savchuk, O.Y. (2017). One-sided cross-validation for nonsmooth densty functions, arXiv:1703.05157.
}
\seealso{
\code{\link{h_OSCV_dens}}, \code{\link{OSCV_Epan_dens}}, \code{\link{OSCV_LI_dens}}, \code{\link{C_smooth}}.
}
