% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OSCV_regfunctions.R
\name{OSCV_reg}
\alias{OSCV_reg}
\title{The OSCV function in the regression context.}
\usage{
OSCV_reg(b, desx, y, ktype)
}
\arguments{
\item{b}{numerical vector of bandwidth values,}

\item{desx}{numerical vecror of design points,}

\item{y}{numerical vecror of data points corresponding to the design points \eqn{desx},}

\item{ktype}{making choice between two cross-validation kernels:  (\eqn{ktype=0}) corresponds to the Gaussian kernel; (\eqn{ktype=1}) corresponds to the robust kernel \code{\link{H_I}} with \eqn{(\alpha,\sigma)=(16.8954588,1.01)}.}
}
\value{
The vector of values of \eqn{OSCV(b)} for the correponsing vector of \eqn{b} values.
}
\description{
Computing \eqn{OSCV(b)}, the value of the OSCV function in the regression context, defined by expression (9) of Savchuk and Hart (2017).
}
\details{
Computation of  \eqn{OSCV(b)} for given \eqn{b} (bandwidth vector) and the data values \eqn{y} corresponding to the design points \eqn{desx}. No preliminary sorting of the data (according to the \eqn{desx} variable) is needed. The value of \eqn{m=4} is used. Two choices of the two-sided cross-validation kernel are available: \itemize{\item (\eqn{ktype=0}) Gaussian kernel; \item (\eqn{ktype=1}) robust kernel \code{\link{H_I}} defined by expression (15) of Savchuk and Hart (2017) with \eqn{(\alpha,\sigma)=(16.8954588,1.01)}.}
}
\examples{
\dontrun{
# The Old Faithful geyser data set "faithful" is used. The sample size n=272.
# The OSCV curves based on the Gaussian kernel and the robust kernel H_I (with 
# alpha=16.8954588 and sigma=1.01) are plotted. The horizontal scales of the curves
# are changed such that their global minimizers are to be used in computing the
# Gaussian local linear estimates of the regression function.
xdat=faithful[[2]] #waiting time
ydat=faithful[[1]] #eruption duration
barray=seq(0.5,10,len=250)
C_gauss=C_smooth(1,1)
OSCV_gauss=OSCV_reg(barray/C_gauss,xdat,ydat,0)
h_gauss=round(h_OSCV_reg(xdat,ydat,0),digits=4)
dev.new()
plot(barray,OSCV_gauss,'l',lwd=3,cex.lab=1.7,cex.axis=1.7,xlab="h",ylab="OSCV criterion")
title(main="OSCV based on the Gaussian kernel",cex.main=1.7)
legend(2.5,0.25,legend=paste("h_min=",h_gauss),cex=2,bty="n")
C_H_I=C_smooth(16.8954588,1.01)
OSCV_H_I=OSCV_reg(barray/C_H_I,xdat,ydat,1)
h_H_I=round(barray[which.min(OSCV_H_I)],digits=4)
dev.new()
plot(barray,OSCV_H_I,'l',lwd=3,cex.lab=1.7,cex.axis=1.7,xlab="h",ylab="OSCV criterion",
ylim=c(0.15,0.5))
title(main="OSCV based on the robust kernel H_I",cex.main=1.7)
legend(2.5,0.4,legend=paste("h_min=",h_H_I),cex=2,bty="n")
}
}
\references{
\itemize{
\item Savchuk, O.Y., Hart, J.D. (2017). Fully robust one-sided cross-validation for regression functions. \emph{Computational Statistics}, doi:10.1007/s00180-017-0713-7.
\item Hart, J.D. and Yi, S. (1998) One-sided cross-validation. \emph{Journal of the American Statistical Association}, 93(442), 620-631.
}
}
\seealso{
\code{\link{h_OSCV_reg}}, \code{\link{H_I}}, \code{\link{loclin}}, \code{\link{C_smooth}}.
}
