% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pointsMap.R
\name{pointsMap}
\alias{pointsMap}
\title{Get map for lat-long points}
\usage{
pointsMap(
  lat,
  long,
  data,
  ext = 0.07,
  fx = 0.05,
  fy = fx,
  type = "osm",
  zoom = NULL,
  minNumTiles = 9L,
  mergeTiles = TRUE,
  map = NULL,
  proj = NA,
  plot = TRUE,
  mar = c(0, 0, 0, 0),
  add = FALSE,
  scale = TRUE,
  quiet = FALSE,
  pch = 3,
  col = "red",
  cex = 1,
  bg = NA,
  pargs = NULL,
  titleargs = NULL,
  ...
)
}
\arguments{
\item{lat, long}{Latitude (North/South) and longitude (East/West) coordinates in decimal degrees}

\item{data}{Optional: data.frame with the columns \code{lat} and \code{long}}

\item{ext}{Extension added in each direction if a single coordinate is given. DEFAULT: 0.07}

\item{fx, fy}{Extend factors (additional map space around actual points)
passed to custom version of \code{\link{extendrange}}. DEFAULT: 0.05}

\item{type}{Tile server in \code{OpenStreetMap::\link[OpenStreetMap]{openmap}}.
For an overview, see \url{https://blog.fellstat.com/?p=356} and
\code{\link{mapComp}}. DEFAULT: "osm"}

\item{zoom, minNumTiles, mergeTiles}{Arguments passed to \code{\link[OpenStreetMap]{openmap}}}

\item{map}{Optional map object. If given, it is not downloaded again.
Useful to project maps in a second step. DEFAULT: NULL}

\item{proj}{If you want to reproject the map (Consumes some extra time), the
proj4 character string or CRS object to project to, e.g. \code{\link{putm}(long=long)}.
DEFAULT: NA (no conversion)}

\item{plot}{Logical: Should map be plotted and points added? Plotting happens with
\code{OpenStreetMap::\link[OpenStreetMap]{plot.OpenStreetMap}(map,
removeMargin=FALSE)}. DEFAULT: TRUE}

\item{mar}{Margins to be set first (and left unchanged). DEFAULT: c(0,0,0,0)}

\item{add}{Logical: add points to existing map? DEFAULT: FALSE}

\item{scale}{Logical: should \code{\link{scaleBar}} be added? DEFAULT: TRUE}

\item{quiet}{Logical: suppress progress messages and non-df warning in 
\code{\link[berryFunctions]{getColumn}}? DEFAULT: FALSE}

\item{pch, col, cex, bg}{Arguments passed to \code{\link{points}},
see \code{pargs} for more. DEFAULT: pch=3, col="red", cex=1, bg=NA}

\item{pargs}{List of arguments passed to \code{\link{points}} like lwd, type, cex, ...}

\item{titleargs}{List of arguments passed to \code{\link{title}} (if not NULL). DEFAULT: NULL}

\item{\dots}{Further arguments passed to \code{\link{scaleBar}} like abslen, ndiv, ...}
}
\value{
Map returned by \code{OpenStreetMap::\link[OpenStreetMap]{openmap}}
}
\description{
Download and plot map with the extend of a dataset with lat-long coordinates.
}
\examples{
if(interactive()){
d <- read.table(sep=",", header=TRUE, text=
"lat, long # could e.g. be copied from googleMaps, rightclick on What's here?
43.221028, -123.382998
43.215348, -123.353804
43.227785, -123.368694
43.232649, -123.355895")

map <- pointsMap(lat, long, data=d)
if(!is.character(map)){ # failed maps return a character string
axis(1, line=-2); axis(2, line=-2) # in whatever unit
map_utm <- pointsMap(lat, long, d, map=map, proj=putm(d$long))
axis(1, line=-2); axis(2, line=-2) # now in meters
projectPoints(d$lat, d$long)
scaleBar(map_utm, x=0.2, y=0.8, unit="mi", type="line", col="red", length=0.25)
pointsMap(lat, long, d[1:2,], map=map_utm, add=TRUE, col="red", pch=3, pargs=list(lwd=3))
}

d <- data.frame(long=c(12.95, 12.98, 13.22, 13.11), lat=c(52.40,52.52, 52.36, 52.45))
map <- pointsMap(lat,long,d, type="bing") # aerial map
}

}
\seealso{
\code{\link{projectPoints}}, \code{OpenStreetMap::\link[OpenStreetMap]{openmap}}
}
\author{
Berry Boessenkool, \email{berry-b@gmx.de}, Jun 2016
}
\keyword{hplot}
\keyword{spatial}
