% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cost.R
\name{cost}
\alias{cost}
\title{Calculate the cost}
\usage{
cost(W,init_list,lambda=0.2)
}
\arguments{
\item{W}{The matrix to be factorized}

\item{init_list}{A list containing the updated results in this iteration}

\item{lambda}{A parameter to set the relative weight of the sparsity constraint}
}
\value{
A number indicating the total cost of the objective function
}
\description{
A function to calculate the cost of the objective function
}
\examples{

W <- simu_data_generation()
init_list <- initialization(W,k=5,l=4)
update_L_list <- update_L(W,init_list)
update_B_list <- update_B(W,update_L_list)
update_R_list <- update_R(W,update_B_list)
update_C_list <- update_C(W,update_R_list,lambda=0.2,rho=1.1)
temp_cost <- cost(W,init_list,lambda=0.2)
}
\author{
Xiaoyao Yin
}
