# MASS/nls-extras.q copyright (C) 1996 D. M. Bates,
# modified (C) 1997 B. D. Ripley.
#
if(version$major < 4) 
{
  "predict.nls"<-
    function(object, newdata = list(), se.fit = FALSE, ...)
  {
    if(!length(newdata) && !length(list(...))) {
      if(!se.fit) {
# most common case
	return(object$fitted)
      }
      newdata <- object$data
      if(!length(newdata)) newdata <- eval(object$call$data)
    }
    ldotdot <- list(...)	
    ## extract the operative part of the formula
    formula <- object$formula
    formula <- formula[[length(formula)]]	
    ## massage newdata and make a frame
    cl <- class(newdata)
    class(newdata) <- NULL
    if(length(ldotdot)) newdata[names(ldotdot)] <- ldotdot
    asgn <- object$assign
    anames <- names(asgn)
    coeff <- object$parameters
    pars <- as.list(parameters(newdata))
    for(i in seq(along = asgn))
      pars[[anames[[i]]]] <- coeff[asgn[[i]]]
    pars$.parameters <- anames
    class(newdata) <- cl
    parameters(newdata) <- pars
    nl.frame <- new.frame(newdata)
# next six lines a replacement by BDR for
# pred <- as.vector(eval(formula, nl.frame))
# which needs later code for pframes than that in S-PLUS 3.x.
    for(i in seq(along = asgn))
      assign(f = nl.frame, anames[[i]], coeff[asgn[[i]]])
    pred <- eval(formula, nl.frame)
    grad <- attr(pred, "gradient")
    pred <- as.vector(pred)
    base <- pred
    nlinear <- 0
    if(inherits(object, "nls.pl")) {
      npar <- max(unlist(asgn))
      lin.pars <- coeff[ - (1:npar)]
      nlinear <- length(lin.pars)
      if(!is.matrix(pred)) pred <- matrix(pred, nc = nlinear)
      pred <- drop(pred %*% lin.pars)
    }
# Addition by BDR of four lines.
    if(se.fit && !length(grad)) {
      warning("se.fit is not implemented without gradients in this version")
      se.fit <- FALSE
    }
    if(se.fit) {
# omit finite-difference case which used calls to compiled code.
      pred <- list(fit = pred)
      fit.summary <- summary.nls(object)
      if(nlinear) {
	if(length(dim(grad)) < 3)
	  grad <- array(grad, c(nobs/nlinear, nlinear, npar))
	gdim <- dim(aperm(grad, c(1, 3, 2)))
	grad <- array(c(array(grad, c(gdim[1] * gdim[2], gdim[3])) %*% 
			lin.pars, base), c(gdim[1], length(coeff))
		      )
      }
      pred$se.fit <- drop((((grad %*% fit.summary$cov) *
			    fit.summary$sigma^2 * grad)
			   %*% rep.int(1, length(coeff)))^0.5)
      pred$residual.scale <- fit.summary$sigma
      pred$df <- fit.summary$df[2]
    }
    pred
  }
  "anova.nls"<-
    function(object, ..., test = c("F", "none", "Chisq", "Cp"))
  {
    if(length(list(...)) == 0) {
      stop("Anova is only defined for sequences of nls objects")
    }
    test <- match.arg(test)
    object <- list(object, ...)
    forms <- sapply(object, function(x) as.character(formula(x)))
    subs <- as.logical(match(forms[2,  ], forms[2, 1], FALSE))
    if(!all(subs))
      warning(paste("Some fit objects deleted because response differs",
		    "from the first model"))
    if(sum(subs) == 1)
      stop("The first model has a different response from the rest")
    forms <- forms[, subs]
    object <- object[subs]
    dfres <- sapply(object, function(x)
		    length(x$residuals) - length(x$parameters))
    dev <- sapply(object, deviance.lm)
    tl <- lapply(object, labels)
    rt <- length(dev)
    effects <- as.character(1:length(dev))
    ddev <-  - diff(dev)
    ddf <-  - diff(dfres)
    heading <- c("Analysis of Variance Table", 
		 paste("\nResponse: ", forms[2, 1], "\n", sep = ""))
    aod <- data.frame(Terms = forms[3,  ], "Resid. Df" = 
		      dfres, RSS = dev, Test = effects, Df = c(NA, ddf), 
		      "Sum of Sq" = c(NA, ddev), check.names = FALSE)
    aod <- as.anova(aod, heading)
    if(test != "none") {
      n <- length(object[[1]]$residuals)
      o <- order(dfres)
      return(stat.anova(aod, test, dev[o[1]]/dfres[o[1]], dfres[o[1]], n))
    }
    aod
  }
  invisible()
}
