% file MASS/leuk.d
% copyright (C) 1994-8 W. N. Venables and B. D. Ripley
%
\name{leuk}
\alias{leuk}
\title{
Survival Times and White Blood Counts for Leukaemia Patients
}
\section{SUMMARY}{
A data frame of data from 33 leukaemia patients.
}
\section{DATA DESCRIPTION}{
A data frame with columns:


}
\arguments{
\item{wbc}{
white blood count
}
\item{ag}{
a test result, \code{"present"} or \code{"absent"}
}
\item{time}{
survival time in weeks
}}
\section{SOURCE}{
D.R. Cox and D. Oakes (1984)
\emph{Analysis of Survival Data, }
Chapman \& Hall, p. 9.  Taken from


Feigl, P. \& Zelen, M. (1965) Estimation of exponential survival
probabilities with concomitant information.
\emph{Biometrics,}
\bold{21}, 826-838.
}
\examples{
library(survival4)
data(leuk)
attach(leuk)
plot(survfit(Surv(time) ~ ag), lty=c(2,3))

# now Cox models
leuk.cox <- coxph(Surv(time) ~ ag+log(wbc))
summary(leuk.cox)
}
\keyword{datasets}
% Converted by Sd2Rd version 0.3-1.
