\name{plot.profile}
\title{Plot Marginal Time Profiles}
\usage{
plot.profile(z, times=NULL, nind=1, mu=NULL, add=FALSE, ylim=NULL,
	lty=NULL, ylab="Fitted value", xlab="Time", ...)
}
\alias{plot.profile}
\arguments{
\item{z}{An object of class recursive, from \code{\link{carma}},
\code{\link{gar}}, \code{\link{kalcount}}, \code{\link{kalseries}},
\code{\link{kalsurv}}, or \code{\link{nbkal}}.}
\item{times}{Vector of time points at which profiles are to be plotted.}
\item{nind}{Observation number(s) of individual(s) to be plotted.}
\item{mu}{The location regression as a function of the parameters and
the times, for the desired covariate values.}
\item{add}{If TRUE, add contour to previous plot instead of creating a
new one.}
\item{others}{Plotting control options.}
}
\value{
\code{plot.profile} is used for plotting marginal profiles over time
for models obtained from Kalman fitting, for given fixed values of
covariates. See \code{\link{plot.iprofile}} for plotting individual
profiles.
}
\seealso{
\code{\link{carma}}, \code{\link{gar}}, \code{\link{kalcount}},
\code{\link{kalseries}}, \code{\link{kalsurv}}, \code{\link{nbkal}}
\code{\link{plot.iprofile}}, \code{\link{plot.residuals}}.
}
\examples{
mu <- function(p) exp(p[1]-p[3])*(dose/(exp(p[1])-exp(p[2]))*
	(exp(-exp(p[2])*tt)-exp(-exp(p[1])*tt)))
shape <- function(p) exp(p[1]-p[2])*tt*dose*exp(-exp(p[1])*tt)
z <- gar(conc, dist="gamma", times, censor=censor, mu=mu, shape=shape,
	preg=c(0.89,-0.77,4), pdep=0.4, psh=c(-1.5,1.17), delta=0.01))
# plot three individual profiles and the average profile
plot.iprofile(z, nind=c(1,12,18), ylim=c(0,1.5), pch=1:3, lty=2:4)
plot.profile(z, nind=c(1,12,18), lty=2:4, add=T)
# or for better resolution
mu1 <- function(p,tt){
   dose <- 50
   exp(p[1]-p[3])*(dose/(exp(p[1])-exp(p[2]))*
	(exp(-exp(p[2])*tt)-exp(-exp(p[1])*tt)))}
plot.profile(z, times=1:24, mu=mu1, add=T)
}
