% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summariseOmopSnapshot.R
\name{summariseOmopSnapshot}
\alias{summariseOmopSnapshot}
\title{Summarise a cdm_reference object creating a snapshot with the metadata of the
cdm_reference object}
\usage{
summariseOmopSnapshot(cdm)
}
\arguments{
\item{cdm}{A \code{cdm_reference} object. Use \emph{CDMConnector} to create a reference
to a database or \emph{omock} to create a reference to synthetic data.}
}
\value{
A \code{summarised_result} object with the results.
}
\description{
Summarise a cdm_reference object creating a snapshot with the metadata of the
cdm_reference object
}
\examples{
\donttest{
library(OmopSketch)
library(omock)

cdm <- mockCdmFromDataset(datasetName = "GiBleed", source = "duckdb")

result <- summariseOmopSnapshot(cdm = cdm)

tableOmopSnapshot(result = result)

cdmDisconnect(cdm = cdm)
}

}
