% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generalfunctions.R
\name{summary_dir}
\alias{summary_dir}
\title{Summary of multiple parameters in a raster directory}
\usage{
summary_dir(path)
}
\arguments{
\item{path}{The path for the Raster* directory or list of Raster* to be
analysed.}
}
\value{
Table with the raster parameters in columns
}
\description{
Listing major characteristics of raster inputs. Those characteristics are the
dimensions, the resolution, the extent, the values (min, max) and the
coordinate reference system.
}
\examples{
\donttest{
url <- "https://zenodo.org/record/3685230/files/SaoLourencoBasin.rda?download=1"
temp <- tempfile()
download.file(url, temp, mode = "wb") # downloading the SaoLourencoBasin dataset
load(temp)
# the acc_changes() function, with the SaoLourencoBasin dataset

summary_dir(raster::unstack(SaoLourencoBasin))
}

}
