% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deleteOMLObject.R
\name{deleteOMLObject}
\alias{deleteOMLObject}
\title{Delete an OpenML object.}
\usage{
deleteOMLObject(
  id,
  object = c("data", "task", "flow", "run", "study"),
  verbosity = NULL
)
}
\arguments{
\item{id}{[\code{integer(1)}]\cr
The ID of the respective object.}

\item{object}{[\code{character(1)}]\cr
A character that specifies the object you want to delete from the server. Can be either
\code{"data"}, \code{"task"}, \code{"flow"} or \code{"run"}.}

\item{verbosity}{[\code{integer(1)}]\cr
Print verbose output on console? Possible values are:\cr
\code{0}: normal output,\cr
\code{1}: info output,\cr
\code{2}: debug output.\cr
Default is set via \code{\link{setOMLConfig}}.}
}
\description{
This will delete one of your uploaded datasets, tasks, flows or runs.
Note that you can only delete the objects you uploaded.
}
\seealso{
Other data set-related functions: 
\code{\link{OMLDataSetDescription}},
\code{\link{OMLDataSet}},
\code{\link{convertMlrTaskToOMLDataSet}()},
\code{\link{convertOMLDataSetToMlr}()},
\code{\link{getOMLDataSet}()},
\code{\link{listOMLDataSets}()},
\code{\link{tagOMLObject}()},
\code{\link{uploadOMLDataSet}()}

Other task-related functions: 
\code{\link{convertOMLTaskToMlr}()},
\code{\link{getOMLTask}()},
\code{\link{listOMLTaskTypes}()},
\code{\link{listOMLTasks}()},
\code{\link{makeOMLTask}()},
\code{\link{tagOMLObject}()}

Other flow-related functions: 
\code{\link{convertOMLFlowToMlr}()},
\code{\link{getOMLFlow}()},
\code{\link{listOMLFlows}()},
\code{\link{makeOMLFlowParameter}()},
\code{\link{makeOMLFlow}()},
\code{\link{tagOMLObject}()}

Other run-related functions: 
\code{\link{convertOMLMlrRunToBMR}()},
\code{\link{convertOMLRunToBMR}()},
\code{\link{getOMLRun}()},
\code{\link{listOMLRuns}()},
\code{\link{makeOMLRunParameter}()},
\code{\link{makeOMLRun}()},
\code{\link{tagOMLObject}()},
\code{\link{uploadOMLRun}()}
}
\concept{data set-related functions}
\concept{flow-related functions}
\concept{run-related functions}
\concept{task-related functions}
