<!-- README.md is generated from README.Rmd. Please edit that file -->

[![Licence](https://img.shields.io/badge/licence-GPL--3-blue.svg)](https://www.gnu.org/licenses/gpl-3.0.en.html)
[![CRAN\_Status\_Badge](http://www.r-pkg.org/badges/version/PAutilities)](https://cran.r-project.org/package=PAutilities)

# PAutilities

This package provides utilities to support a range of tasks in physical
activity research. These include the items in the list below, which is
expected to grow and mature over time. Feature/pull requests are
encouraged!

  - Activity intensity classification from metabolic equivalents and (if
    available) posture
  - Analysis of bout detection (i.e., change point detection) algorithm performance
  - Assessment of cardiovascular disease risk
  - Bland-Altman analysis and plotting
  - ~~Bouted moderate-to-vigorous physical activity analysis~~ (now recommend using `analyze_bouts` from [PBpatterns](https://github.com/paulhibbing/PBpatterns))
  - ~~Demographic and anthropometric calculations (age, BMI, BMI-for-age
    percentile, weight status)~~ (now recommend using [anthropometry](https://github.com/paulhibbing/anthropometry))
  - Formatted descriptive statistics
  - Indexed run length encoding
  - Metabolic calculations (energy expenditure, unit conversions, resting energy
    expenditure predictions, sliding window resting metabolic rate calculations)
  - Paired equivalence testing (including a plot method)
  - Programming management (e.g. runtime updates, object comparisons)
  - Reordering data frame variables
