% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_bmi.R
\name{get_bmi}
\alias{get_bmi}
\alias{get_wt_kg}
\alias{get_ht_m2}
\alias{bmi_check}
\alias{target_wt}
\title{Calculate body mass index}
\usage{
get_bmi(
  wt,
  wt_unit = c("kg", "lb", "oz", "st"),
  ht,
  ht_unit = c("cm", "m", "in", "ft"),
  target = NULL
)

get_wt_kg(wt, wt_unit = c("kg", "lb", "oz", "st"))

get_ht_m2(ht, ht_unit = c("cm", "m", "in", "ft"))

bmi_check(bmi)

target_wt(
  target,
  ht,
  ht_unit = c("cm", "m", "in", "ft"),
  wt_unit = c("kg", "lb", "oz", "st")
)
}
\arguments{
\item{wt}{body mass}

\item{wt_unit}{character. Units of body mass (or desired units if
\code{target} is passed. See below.)}

\item{ht}{height}

\item{ht_unit}{character. Units of height}

\item{target}{an optional target BMI (kg/m^2), for which the corresponding
body mass will be returned}

\item{bmi}{internal argument}
}
\value{
If \code{target} is \code{NULL} (default), the function returns the
  body mass index. If \code{target} is provided, the function will use
  \code{target} and \code{ht} to back-calculate a target body mass in the
  units defined by \code{wt_unit} (kg by default).
}
\description{
Calculate body mass index
}
\examples{
get_bmi(160, "lb", 180, "cm")
get_bmi(ht = 5.90, ht_unit = "ft", target = 24, wt_unit = "st")
get_bmi(wt = c(60:79, NA), ht = c(NA, 160:179))
}
\keyword{internal}
