% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/new_paired_equivalence.R
\name{new_paired_equivalence}
\alias{new_paired_equivalence}
\title{A combined constructor and validator for \code{paired_equivalence} objects}
\usage{
new_paired_equivalence(
  x,
  y,
  y_type = c("both", "criterion", "comparison"),
  alpha = 0.05,
  na.rm = TRUE,
  scale = c("relative", "absolute"),
  absolute_region_width = NULL,
  relative_region_width = NULL
)
}
\arguments{
\item{x}{numeric vector representing the (possibly surrogate) sample}

\item{y}{numeric vector representing the (possibly criterion) sample. Index
paired with \code{x}}

\item{y_type}{classification of \code{y} for the purpose of analysis. Can be
\code{"criterion"}, \code{"comparison"}, or \code{"both"}.}

\item{alpha}{the alpha level for the test}

\item{na.rm}{logical. Omit mean values for mean calculations?}

\item{scale}{character specifying whether the test should occur on an
absolute or relative scale. Must be one of \code{"relative"} (default) or
\code{"absolute"}.}

\item{absolute_region_width}{the region width for use when \code{scale =
"absolute"}}

\item{relative_region_width}{the region width for use when \code{scale =
"relative"}}
}
\value{
an initialized \code{paired_equivalence} object
}
\description{
A combined constructor and validator for \code{paired_equivalence} objects
}
\keyword{internal}
