% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/anglePlot.R
\name{anglePlot}
\alias{anglePlot}
\title{Angle plot}
\usage{
anglePlot(x)
}
\arguments{
\item{x}{A \code{PCADSC} or \code{angleInfo} object, as produced by \code{\link{PCADSC}} or
\code{\link{doAngle}}, respectively.}
}
\description{
Produce an angle plot from a full or partial \code{PCADSC} object, as obtained
from a call to \code{\link{PCADSC}}. In either case, this \code{PCADSC} object must have a
non-\code{NULL} \code{anleInfo} slot (see examples). The angle plot compares the eigenvalue-
and loading patterns from PCA performed on two datasets that consist of different observations
of the same variables.
}
\examples{
#load iris data
data(iris)

#Define grouping variable, grouping the observations by whether their species is
#Setosa or not
iris$group <- "setosa"
iris$group[iris$Species != "setosa"] <- "non-setosa"
iris$Species <- NULL

\dontrun{
#make a full PCADSC object, splitting the data by "group"
irisPCADSC <- PCADSC(iris, "group")

#make a partial PCADSC object from iris and fill out angleInfo in the next call
irisPCADSC2 <- PCADSC(iris, "group", doAngle = FALSE)
irisPCADSC2 <- doAngle(irisPCADSC2)

#make an angle plot
anglePlot(irisPCADSC)
anglePlot(irisPCADSC2)
}

#Only do angle information for a faster run-time
irisPCADSC_fast <- PCADSC(iris, "group", doCE = FALSE, doChroma = FALSE)
anglePlot(irisPCADSC_fast)

}
\seealso{
\code{\link{PCADSC}}, \code{\link{doAngle}}
}

