% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PCBN-find-copula-specified.R
\name{find_cond_copula_specified}
\alias{find_cond_copula_specified}
\title{Find among parents of a node, the one that has a conditional copula specified}
\usage{
find_cond_copula_specified(DAG, order_hash, v, cond)
}
\arguments{
\item{DAG}{Directed Acyclic Graph object corresponding to the model}

\item{order_hash}{hashmap of orders of the parental sets}

\item{v}{node in DAG}

\item{cond}{vector of nodes in DAG. This must not be empty.
It is assumed that conditionally independent nodes have already been
removed by the function \code{\link{remove_CondInd}}.
It is assumed to have been already sorted.}
}
\value{
a list with \itemize{
   \item a node \code{w} such that the conditional copula
   \eqn{C_{w, v | cond[-v]}} has been specified in the model.

   If no such node can be found, an error message is raised.

   \item the set \code{cond[-v]}
}
}
\description{
Find among parents of a node, the one that has a conditional copula specified
}
\examples{

DAG = create_empty_DAG(3)
DAG = bnlearn::set.arc(DAG, 'U1', 'U3')
DAG = bnlearn::set.arc(DAG, 'U2', 'U3')

order_hash = r2r::hashmap()
order_hash[['U3']] = c("U1", "U2")

find_cond_copula_specified(DAG = DAG, order_hash = order_hash,
                           v = "U3", cond = c("U1"))
# returns "U1" because the copula c_{1,3} is known

find_cond_copula_specified(DAG = DAG, order_hash = order_hash,
                           v = "U3", cond = c("U1", "U2"))
# returns "U2" because the copula c_{2,3|1} is known


}
