\name{cvpcplus}
\alias{cvpcplus}
\alias{cv.pcplus}

\title{Tuning parameter selection by crossvalidation}
\description{Selects the tuning parameters, bandwidth and the penalty lambda, of the \acronym{PCpluS} estimator \cite{F. Pein (2021)}. The values obtained can be used in the estimator \code{\link{pcplus}}.}

\usage{
cv.pcplus(y, bandwidth, lambda, nbandwidth = 30L, nlambda = 30L,
          lambda.min.ratio = 0.01, sd = NULL, thresh = 1e-7, maxit = 1e5L)
}

\arguments{
\item{y}{a numeric vector containing the observations, only finite values are allowed}
\item{bandwidth}{a numeric vector specifying possible values for the bandwidth of the kernel smoother; each entry must be between \code{2 / length(n)} and \code{0.25} or \code{Inf}, smaller values are replaced by \code{2 / n} and larger by \code{Inf} with a warning; see \cite{F. Pein (2021)} for an interpretation of \code{bandwidth == Inf}. If missing an exponential grid of length \code{nbandwidth} will be used}
\item{lambda}{a decreasing sequence of numerics specifying possible values for the penalty penalty of the fused lasso; each value must be positive. If missing an exponential grid of length \code{nlambda} is used}
\item{nbandwidth}{a single integer giving the length of the grid for \code{bandwidth}; ignored if \code{bandwidth} is given}
\item{nlambda}{a single integer giving the length of the grid for \code{lambda}; ignored if \code{lambda} is given}
\item{lambda.min.ratio}{a single numeric between \code{0} and \code{1} speciyfing the range of the grid for \code{lambda}; ignored if \code{lambda} is given. More precisely, for each \code{bandwdith} value the largest value of the grid is chosen such that no changes are found and the smallest value is the largest value times \code{lambda.min.ratio}}
\item{sd}{a single positive value giving the standard deviation of the observations; may be \code{NULL}, in which case a robust estimator is used}
\item{thresh}{a single positive numeric value giving a convergence threshold for coordinate descent. Each inner coordinate-descent loop continues until the maximum change in the objective after any coefficient update is less than \code{thresh} times the null deviance}
\item{maxit}{a single positive integer giving the maximum number of passes over the data for all lambda values}
}

\value{
a \code{\link{list}} containing the entries \code{lambda} and \code{bandwidth} giving the best parameter for the tuning parameters. Both can be passed directly to \code{\link{pcplus}}. Note that \code{lambda} is a decaying sequence instead of a single value. This improves the runtime of the estimator. The last value is the suggested tuning parameter. Furthermoore, it has the entries \code{cv} with the loss for the selected parameters, \code{bandwidths} with the grid of bandwidths used, and \code{cvs} with the loss for all bandwidths.
}

\seealso{\code{\link{pcplus}}}

\references{
Pein, F. (2021). Change-point regression with a smooth additive disturbance. \emph{arXiv preprint} arXiv:2112.03878.
} 

\examples{
library(PCpluS)
set.seed(1)
y <- c(rnorm(125), rnorm(125, 3)) + sin(2 * pi * 1:250 / 250)

CV <- cv.pcplus(y)
ret <- pcplus(y, lambda = CV$lambda, bandwidth = CV$bandwidth)

plot(y, pch = 16)
lines(ret$est, col = "red")
abline(v = ret$cps)
}

\keyword{nonparametric}
