% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/02_BIVARIATE_ANALYSIS.R
\name{auc.model}
\alias{auc.model}
\title{Area under curve (AUC)}
\usage{
auc.model(predictions, observed)
}
\arguments{
\item{predictions}{Model predictions.}

\item{observed}{Observed values of target variable.}
}
\value{
The command \code{auc.model} returns value of AUC.
}
\description{
\code{auc.model} calculates area under curve (AUC) for a given predicted values and observed target variable.
}
\examples{
suppressMessages(library(PDtoolkit))
data(gcd)
#categorize numeric risk factor
gcd$maturity.bin <- ndr.bin(x = gcd$maturity, y = gcd$qual, y.type = "bina")[[2]]
#estimate simple logistic regression model
lr <- glm(qual ~ maturity.bin, family = "binomial", data = gcd)
#calculate auc
auc.model(predictions = predict(lr, type = "response", newdata = gcd),
    observed = gcd$qual)
}
\seealso{
\code{\link{bivariate}} for automatic bivariate analysis.
}
