% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/06_MODEL_CV_BOOTS.R
\name{boots.vld}
\alias{boots.vld}
\title{Bootstrap model validation}
\usage{
boots.vld(model, B = 1000, seed = 1122)
}
\arguments{
\item{model}{Model in use, an object of class inheriting from \code{"glm"}.}

\item{B}{Number of bootstrap samples. Default is set to 1000.}

\item{seed}{Random seed needed for ensuring the result reproducibility. Default is 1122.}
}
\value{
The command \code{boots.vld} returns a list of two objects.\cr
The first object (\code{iter}), returns iteration performance metrics.\cr
The second object (\code{summary}), is the data frame of iterations averages of performance metrics.
}
\description{
\code{boots.vld} performs bootstrap model validation.
The goal of this procedure is to generate main model performance metrics such as absolute mean
square error, root mean square error or area under curve (AUC) based on resampling method.
}
\examples{
suppressMessages(library(PDtoolkit))
data(loans)
#run stepFWD
res <- stepFWD(start.model = Creditability ~ 1, 
                p.value = 0.05, 
	   coding = "WoE",
	   db = loans)
#check output elements
names(res)
#extract the final model
final.model <- res$model
#print coefficients
summary(final.model)$coefficients
#print head of coded development data
head(res$dev.db)
#calculate AUC
auc.model(predictions = predict(final.model, type = "response", newdata = res$dev.db),
    observed = res$dev.db$Creditability)
boots.vld (model = final.model, B = 10, seed = 1122)
}
