% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/covtest.R
\name{covtest}
\alias{covtest}
\title{Two-sample covariance tests for high-dimensional data}
\usage{
covtest(dataX,dataY,method='pe.comp',delta=NULL)
}
\arguments{
\item{dataX}{an \eqn{n_1} by \eqn{p} data matrix}

\item{dataY}{an \eqn{n_2} by \eqn{p} data matrix}

\item{method}{the method type (default = \code{'pe.comp'});
chosen from
\itemize{
\item \code{'clx'}: the \eqn{l_\infty}-norm-based covariance test, proposed in Cai et al. (2013); \cr
see \code{\link{covtest.clx}} for details.
\item \code{'lc'}: the \eqn{l_2}-norm-based covariance test, proposed in Li and Chen (2012); \cr
see \code{\link{covtest.lc}} for details.
\item \code{'pe.cauchy'}: the PE covariance test via Cauchy combination; \cr
see \code{\link{covtest.pe.cauchy}} for details.
\item \code{'pe.comp'}: the PE covariance test via the construction of PE components; \cr
see \code{\link{covtest.pe.comp}} for details.
\item \code{'pe.fisher'}: the PE covariance test via Fisher's combination; \cr
see \code{\link{covtest.pe.fisher}} for details.
}}

\item{delta}{This is needed only in \code{method='pe.comp'};
see \code{\link{covtest.pe.comp}} for details.
The default is NULL.}
}
\value{
\code{method} the method type

\code{stat} the value of test statistic

\code{pval} the p-value for the test.
}
\description{
This function implements five two-sample covariance tests on high-dimensional
covariance matrices.
Let \eqn{\mathbf{X} \in \mathbb{R}^p} and \eqn{\mathbf{Y} \in \mathbb{R}^p}
be two \eqn{p}-dimensional populations with mean vectors
\eqn{(\boldsymbol{\mu}_1, \boldsymbol{\mu}_2)} and covariance matrices
\eqn{(\mathbf{\Sigma}_1, \mathbf{\Sigma}_2)}, respectively.
The problem of interest is to test the equality of the two
covariance matrices:
\deqn{H_{0c}: \mathbf{\Sigma}_1 = \mathbf{\Sigma}_2. }
Suppose \eqn{\{\mathbf{X}_1, \ldots, \mathbf{X}_{n_1}\}} are i.i.d.
copies of \eqn{\mathbf{X}}, and \eqn{\{\mathbf{Y}_1, \ldots, \mathbf{Y}_{n_2}\}}
are i.i.d. copies of \eqn{\mathbf{Y}}. We denote
\code{dataX=}\eqn{(\mathbf{X}_1, \ldots, \mathbf{X}_{n_1})^\top\in\mathbb{R}^{n_1\times p}}
and \code{dataY=}\eqn{(\mathbf{Y}_1, \ldots, \mathbf{Y}_{n_2})^\top\in\mathbb{R}^{n_2\times p}}.
}
\examples{
n1 = 100; n2 = 100; pp = 500
set.seed(1)
X = matrix(rnorm(n1*pp), nrow=n1, ncol=pp)
Y = matrix(rnorm(n2*pp), nrow=n2, ncol=pp)
covtest(X,Y)
}
\references{
Cai, T. T., Liu, W., and Xia, Y. (2013). Two-sample covariance matrix testing
and support recovery in high-dimensional and sparse settings.
\emph{Journal of the American Statistical Association}, 108(501):265–277.

Li, J. and Chen, S. X. (2012). Two sample tests for high-dimensional
covariance matrices. \emph{The Annals of Statistics}, 40(2):908–940.

Yu, X., Li, D., and Xue, L. (2022). Fisher’s combined probability test
for high-dimensional covariance matrices. \emph{Journal of the American
Statistical Association}, (in press):1–14.

Yu, X., Li, D., Xue, L., and Li, R. (2022). Power-enhanced simultaneous test
of high-dimensional mean vectors and covariance matrices with application
to gene-set testing. \emph{Journal of the American Statistical Association},
(in press):1–14.
}
