% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MultiplicativeAlgorithm.R
\name{MultiplicativeAlgorithm}
\alias{MultiplicativeAlgorithm}
\title{MultiplicativeAlgorithm}
\usage{
MultiplicativeAlgorithm(
  name = character(0),
  modelEquations = list(),
  modelFromLibrary = list(),
  modelParameters = list(),
  modelError = list(),
  optimizer = character(0),
  optimizerParameters = list(),
  outputs = list(),
  designs = list(),
  fimType = character(0),
  fim = Fim(),
  odeSolverParameters = list(),
  optimisationDesign = list(),
  optimisationAlgorithmOutputs = list(),
  lambda = 0,
  delta = 0,
  numberOfIterations = 0,
  weightThreshold = 0,
  showProcess = FALSE,
  multiplicativeAlgorithmOutputs = list()
)
}
\arguments{
\item{name}{A string giving the name of the design evaluation.}

\item{modelEquations}{A list giving the model equations.}

\item{modelFromLibrary}{A list giving the model equations from the library of model.}

\item{modelParameters}{A list giving the model parameters.}

\item{modelError}{A list giving the model error.}

\item{optimizer}{A string giving the name of the optimization algorithm being used.}

\item{optimizerParameters}{A list giving the parameters of the optimization algorithm.}

\item{outputs}{A list giving the model outputs.}

\item{designs}{A list giving the designs to be evaluated.}

\item{fimType}{A string giving the type of Fim being evaluated.}

\item{fim}{A object \code{Fim} giving the Fim.}

\item{odeSolverParameters}{A list giving the atol and rtol parameters for the ode solver.}

\item{optimisationDesign}{A list giving the evaluation of initial and optimal design.}

\item{optimisationAlgorithmOutputs}{A list giving the outputs of the optimization process.}

\item{lambda}{A numeric giving the parameter lambda.}

\item{delta}{A numeric giving the parameter delta}

\item{numberOfIterations}{A numeric giving the number of iterations.}

\item{weightThreshold}{A numeric giving the weight threshold.}

\item{showProcess}{A Boolean for displaying the process or not.}

\item{multiplicativeAlgorithmOutputs}{A list giving the output of the optimization algorithm.}
}
\description{
The class \code{MultiplicativeAlgorithm} implements the multiplicative algorithm.
}
