% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/network.R
\name{network}
\alias{network}
\title{This function enumerates conditional sample spaces associated with logistic regression,}
\usage{
network(
  dm,
  n = NULL,
  resp = NULL,
  conditionon = NULL,
  sst = NULL,
  addint = TRUE,
  verbose = FALSE,
  data.name = "Test data"
)
}
\arguments{
\item{dm}{matrix of covariates}

\item{n}{Vector of number of trials.  If null, make them all ones.}

\item{resp}{vector of successes.  Used only to calculate the sufficient statistics, unless
sufficient statistics are entered directly.  Either resp or sst must be provided.}

\item{conditionon}{indices of covariate matrix indicating sufficient statistics to be conditioned on.}

\item{sst}{sufficient statistic vector, if input directly.  Otherwise, recomputed from resp.}

\item{addint}{logical, true if a column of 1s must be added to the covariate matrix.}

\item{verbose}{logical; if true, print intermediate results.}

\item{data.name}{Name of the data set.}
}
\value{
For a successful run, a list with components:
\itemize{
  \item possible   matrix with vectors of possible unconditioned values of the sufficient statistic.
  \item count   count of entries in the conditional distribution.
  \item obsd   Observed value of unconditioned sufficient statistics.
}
For an unsuccessful run (because of input inconsistencies) NA
}
\description{
This function uses a network algorithm to enumerate conditional sample spaces associated with logistic regression,
using a minimal version of the algorithm of \insertCite{mehtapatel;textual}{PHInfiniteEstimates}.
}
\details{
Examples apply this to data from \insertCite{mehtapatel;textual}{PHInfiniteEstimates}, 
citing \insertCite{goorinetal87;textual}{PHInfiniteEstimates}.
}
\examples{
#Columns in table are:
# Lymphocytic Infiltration (1=low, 0=high)
# Sex (1=male, 0=female)
# Any Ostioid Pathology (1=yes, 0=no)
# Number in LI-Sex-AOP group
# Number in LI-Sex-AOP group with disease free interval greater than 3 y
goorin<-data.frame(LI=c(0,0,0,0,1,1,1,1),Sex=c(0,0,1,1,0,0,1,1),
   AOP=c(0,1,0,1,0,1,0,1),N=c(3,2,4,1,5,5,9,17),Y=c(3,2,4,1,5,3,5,6))
\donttest{
out<-network(goorin[,1:3],goorin[,4],conditionon=1:3,resp=goorin[,5])
inference(out)
}
}
\references{
\insertRef{mehtapatel}{PHInfiniteEstimates}

\insertRef{goorinetal87}{PHInfiniteEstimates}
}
