% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_adjpin.R
\name{initials_adjpin}
\alias{initials_adjpin}
\title{AdjPIN initial parameter sets of Ersan & Ghachem (2022b)}
\usage{
initials_adjpin(data, xtraclusters = 4, restricted = list(),
 verbose = TRUE)
}
\arguments{
\item{data}{A dataframe with 2 variables: the first
corresponds to buyer-initiated trades (buys), and the second corresponds
to seller-initiated trades (sells).}

\item{xtraclusters}{An integer used to divide trading days into
#\code{(4 + xtraclusters)} clusters, thereby resulting in
#\code{comb(4 + xtraclusters - 1, 4 - 1)} initial parameter sets in line
with \insertCite{ErsanAlici2016;textual}{PINstimation}, and
\insertCite{Ersan2022b;textual}{PINstimation}.The default value is \code{4} as
chosen in \insertCite{Ersan2016;textual}{PINstimation}.}

\item{restricted}{A binary list that allows estimating restricted
AdjPIN models by specifying which model parameters are assumed to be equal.
It contains one or multiple of the following four elements
\verb{\{theta, mu, eps, d\}}. For instance, If \code{theta} is set to \code{TRUE},
then the probability of liquidity shock in no-information days, and in
information days is assumed to be the same (\thetaB\code{=}\thetaS). If any of
the remaining rate elements \verb{\{mu, eps, d\}} is set to \code{TRUE},
(say  \code{mu=TRUE}), then the rate is assumed to be the same on the buy side,
and on the sell side (\mub\code{=}\mus). If more than one element is set to
\code{TRUE}, then the restrictions are combined. For instance, if the argument
\code{restricted} is set to \code{list(theta=TRUE, eps=TRUE, d=TRUE)}, then the
restricted AdjPIN model is estimated, where \thetaB\code{=}\thetaS, \eb\code{=}\es,
and \Db\code{=}\Ds. If the value of the argument \code{restricted} is the empty list,
then all parameters of the model are assumed to be independent,
and the unrestricted model is estimated. The default value is the empty
list \code{list()}.}

\item{verbose}{a binary variable that determines whether information messages
about the initial parameter sets, including the number of the initial
parameter sets generated. No message is shown when \code{verbose} is set
to \code{FALSE}. The default value is \code{TRUE}.}
}
\value{
Returns a dataframe of numerical vectors of ten elements
\{\eqn{\alpha}, \eqn{\delta}, \eqn{\theta}, \eqn{\theta'},
\eb, \es, \mub, \mus, \Db, \Ds\}.
}
\description{
Based on the algorithm in \insertCite{Ersan2022b;textual}{PINstimation},
generates sets of initial parameters to be used in the maximum likelihood
estimation of \code{AdjPIN} model.
}
\details{
The argument 'data' should be a numeric dataframe, and contain
at least two variables. Only the first two variables will be considered:
The first variable is assumed to correspond to the total number of
buyer-initiated trades, while the second variable is assumed to
correspond to the total number of seller-initiated trades. Each row or
observation correspond to a trading day. \code{NA} values will be ignored.

The function \code{initials_adjpin()} implements the algorithm suggested in
\insertCite{Ersan2022b;textual}{PINstimation}, and uses a hierarchical
agglomerative clustering (HAC) to find initial parameter sets for
the maximum likelihood estimation.
}
\examples{
# There is a preloaded quarterly dataset called 'dailytrades' with 60
# observations. Each observation corresponds to a day and contains the
# total number of buyer-initiated trades ('B') and seller-initiated
# trades ('S') on that day. To know more, type ?dailytrades

xdata <- dailytrades

# Obtain a dataframe of initial parameter sets for the maximum likelihood
# estimation using the algorithm of Ersan and Ghachem (2022b).

init.sets <- initials_adjpin(xdata)

# Use the list to estimate adjpin using the adjpin() method
# Show the value of adjusted PIN

estimate <- adjpin(xdata, initialsets = init.sets, verbose = FALSE)
show(estimate@adjpin)

}
\references{
\insertAllCited
}
