% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_pin.R
\name{initials_pin_ea}
\alias{initials_pin_ea}
\title{Initial parameter sets of Ersan & Alici (2016)}
\usage{
initials_pin_ea(data, xtraclusters = 4, verbose = TRUE)
}
\arguments{
\item{data}{A dataframe with 2 variables: the first
corresponds to buyer-initiated trades (buys), and the second corresponds
to seller-initiated trades (sells).}

\item{xtraclusters}{An integer used to divide trading days into
\code{#(2 + xtraclusters)} clusters, thereby resulting in
\verb{#comb(1 + xtraclusters, 1)} initial parameter sets in line with
\insertCite{ErsanAlici2016;textual}{PINstimation}. The default value is \code{4}.}

\item{verbose}{a binary variable that determines whether information messages
about the initial parameter sets, including the number of the initial
parameter sets generated. No message is shown when \code{verbose} is set
to \code{FALSE}. The default value is \code{TRUE}.}
}
\value{
Returns a dataframe of initial sets each consisting of five
variables \{\eqn{\alpha}, \eqn{\delta}, \eqn{\mu}, \eb, \es\}.
}
\description{
Based on the algorithm in Ersan and Alici (2016),
generates initial parameter sets for the maximum likelihood
estimation of the \code{PIN} model.
}
\details{
The argument 'data' should be a numeric dataframe, and contain
at least two variables. Only the first two variables will be considered:
The first variable is assumed to correspond to the total number of
buyer-initiated trades, while the second variable is assumed to
correspond to the total number of seller-initiated trades. Each row or
observation correspond to a trading day. \code{NA} values will be ignored.

The function \code{initials_pin_ea()} uses a hierarchical agglomerative
clustering (HAC) to find initial parameter sets for
the maximum likelihood estimation. The steps in
\insertCite{ErsanAlici2016;textual}{PINstimation} algorithm differ from those
used by \insertCite{Gan2015;textual}{PINstimation}, and are summarized below.

Via the use of HAC, daily absolute order imbalances (AOIs) are grouped in
\code{2+J} (default \code{J=4}) clusters. After sorting the clusters based on
AOIs, they are combined into two larger groups of days (event and no-event)
by merging neighboring clusters with each other. Consequently, those groups
are formed in \verb{#comb(5, 1) = 5} different ways. For each of the \code{5}
configurations with which, days are grouped into two (event group and
no-event group), the procedure below is applied to obtain initial parameter
sets. \cr\cr
Days in the event group (the one with larger mean AOI) are distributed into
two groups, i.e. good-event days (days with positive OI) and bad-event days
(days with negative OI).
Initial parameters are obtained from the frequencies, and average trade
rates of three types of days. See
\insertCite{ErsanAlici2016;textual}{PINstimation} for further details.\cr\cr
The higher the number of the additional clusters (\code{xtraclusters}), the
better is the estimation. \insertCite{ErsanAlici2016;textual}{PINstimation},
however, have shown the benefit of increasing this number beyond 4 is
marginal, and statistically insignificant.
}
\examples{
# There is a preloaded quarterly dataset called 'dailytrades' with 60
# observations. Each observation corresponds to a day and contains the
# total number of buyer-initiated trades ('B') and seller-initiated
# trades ('S') on that day. To know more, type ?dailytrades

xdata <- dailytrades

# Obtain a dataframe of initial parameters for the maximum likelihood
# estimation using the algorithm of Ersan and Alici (2016).

init.sets <- initials_pin_ea(xdata)

# Use the obtained dataframe to estimate the PIN model using the function
# pin() with custom initial parameter sets

estimate.1 <- pin(xdata, initialsets = init.sets, verbose = FALSE)

# pin_ea() directly estimates the PIN model using initial parameter sets
# generated using the algorithm of Ersan & Alici (2016).

estimate.2 <- pin_ea(xdata, verbose = FALSE)

# Check that the obtained results are identical

show(estimate.1@parameters)
show(estimate.2@parameters)

}
\references{
\insertAllCited
}
