% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ThreeComp_Volume_RateConstant.R
\name{ThreeComp_Volume_RateConstant}
\alias{ThreeComp_Volume_RateConstant}
\title{Convert pharmacokinetic parameters for three compartment model}
\usage{
ThreeComp_Volume_RateConstant(V1,k10,k12,k13,k21,k31,
 V1.sd=NA,k10.sd=NA,k12.sd=NA,
 k13.sd=NA,k21.sd=NA,k31.sd=NA,covar=c(V1k10=NA,V1k12=NA,V1k13=NA,
   V1k21=NA,V1k31=NA,k10k12=NA,k10k13=NA,k10k21=NA,k10k31=NA,
   k12k13=NA,k12k21=NA,k12k31=NA,k13k21=NA,k13k31=NA,k21k31=NA),...)
}
\arguments{
\item{V1}{The volume of distribution of compartment 1}

\item{k10}{elimination rate constant}

\item{k12}{transfer rate constants from compartment 1 to compartment 2}

\item{k13}{transfer rate constants from compartment 1 to compartment 3}

\item{k21}{transfer rate constants from compartment 2 to compartment 1}

\item{k31}{transfer rate constants from compartment 3 to compartment 1}

\item{V1.sd}{standard error of V1}

\item{k10.sd}{standard error of k10}

\item{k12.sd}{standard error of k12}

\item{k13.sd}{standard error of k13}

\item{k21.sd}{standard error of k21}

\item{k31.sd}{standard error of k31}

\item{covar}{covariances among parameters}

\item{...}{arguments to be passed to methods}
}
\description{
Calculate pharmacokinetic parameters with volume of distribution (V1),
elimination rate constant (k10), and transter rate constants
(k12, k13, k21, and k31)
}
\examples{
ThreeComp_Volume_RateConstant(V1=10,k10=0.3,k12=0.2,k13=0.1,k21=0.02,
         k31=0.001,V1.sd=0.1,k10.sd=0.002,k12.sd=0.001,
         k13.sd=0.0005,k21.sd=0.0005,k31.sd=0.000005)
}
\references{
\url{http://www.nonmemcourse.com/convert.xls}
}
