% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TwoComp_Volume_Exponent.R
\name{TwoComp_Volume_Exponent}
\alias{TwoComp_Volume_Exponent}
\title{Convert pharmacokinetic parameters for two compartment model}
\usage{
TwoComp_Volume_Exponent(V1,alpha,beta,k21,V1.sd=NA,
 alpha.sd=NA,beta.sd=NA,k21.sd=NA,
 covar=c(V1alpha=NA,V1beta=NA,V1k21=NA,alphabeta=NA,
 alphak21=NA,betak21=NA),...)
}
\arguments{
\item{V1}{The volume of distribution of compartment 1}

\item{alpha}{parameter in one compartment model "Aexp(-alpha)"}

\item{beta}{parameter in two compartment model "Aexp(-alpha)+Bexp(-beta)"}

\item{k21}{transfer rate constants from compartment 2 to compartment 1}

\item{V1.sd}{standard error of V1}

\item{alpha.sd}{standard error of alpha}

\item{beta.sd}{standard error of beta}

\item{k21.sd}{standard error of k21}

\item{covar}{covariances among parameters}

\item{...}{arguments to be passed to methods}
}
\description{
Calculate pharmacokinetic parameters with volume of distribution(V1),
transfer rate constant (k12), and parameters (alpha and beta)
in the model "Aexp(-alpha)+Bexp(-beta)"
}
\examples{
TwoComp_Volume_Exponent(V1=5,alpha=1.221, beta=0.029, k21=0.05,
V1.sd=0.01,alpha.sd=0.01,beta.sd=0.00005,k21.sd=0.0006)
}
\references{
\url{http://www.nonmemcourse.com/convert.xls}
}
