% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PLMIXfunctions.R
\name{freq_to_unit}
\alias{freq_to_unit}
\title{Individual rankings/orderings from the frequency distribution}
\usage{
freq_to_unit(freq_distr)
}
\arguments{
\item{freq_distr}{Numeric matrix of the distinct observed sequences with the corresponding frequencies indicated in the last \eqn{(K+1)}-th column.}
}
\value{
Numeric \eqn{N}\eqn{\times}{x}\eqn{K} data matrix of observed individual sequences.
}
\description{
Construct the dataset of individual rankings/orderings from the frequency distribution of the distinct observed sequences.
}
\examples{

library(e1071)
K <- 4
perm_matrix <- permutations(n=K)
freq_data <- cbind(perm_matrix, sample(1:factorial(K)))
freq_data
freq_to_unit(freq_distr=freq_data)

}
\author{
Cristina Mollica and Luca Tardella
}
