\name{poisson.MODpq.log}
\alias{poisson.MODpq.log}

\title{
Generation of multivariate count time series from a log-linear Poisson NAR(p) model with q covariates
(log-PNAR(p))
}

\description{
Generation of counts from a log-linear Poisson Network Autoregressive model of
order \eqn{p} with \eqn{q} covariates (log-PNAR(\eqn{p})).
}

\usage{
poisson.MODpq.log(b, W, p, Z = NULL, TT, N, copula = "gaussian",
corrtype = "equicorrelation", rho, dof = 1)
}

\arguments{
\item{b}{
The coefficients of the model, in the following order: (intercept, network
parameters, autoregressive parameters, covariates). The dimension of the vector
should be \eqn{2p + 1 + q}, where \eqn{q} denotes the number of covariates.
}
\item{W}{
The \eqn{N \times N} row-normalized non-negative adjacency matrix describing
the network. The main diagonal entries of the matrix should be zeros, all the
other entries should be non-negative and the maximum sum of elements over the
rows should equal one.The function row-normalizes the matrix if a non-normalized
adjacency matrix is provided.
}
\item{p}{
The number of lags in the model.
}
\item{Z}{
An \eqn{N \times q} matrix of covariates (one for each column),
where \eqn{q} is the number of covariates in the model.
}
\item{TT}{
The temporal sample size.
}
\item{N}{
The number of nodes on the network.
}
\item{copula}{
Which copula function to use? The "gaussian", "t", or "clayton".
}
\item{rho}{
The the value of the copula parameter (\eqn{\rho}). A scalar in \eqn{[-1,1]}
for elliptical copulas (Gaussian, t), a value greater or equal to -1 for
Clayton copula.
}
\item{corrtype}{
Used only for elliptical copulas. The type of correlation matrix employed for
the copula; it will either be the "equicorrelation" or "toeplitz". The
"equicorrelation" option generates a correlation matrix where all the off-diagonal
entries equal \eqn{\rho}. The "toeplitz" option generates a correlation matrix
whose generic off-diagonal \eqn{(i,j)}-element is \eqn{\rho^{|i-j|}}.
}
\item{dof}{
The degrees of freedom for Student's t copula.
}
}

\details{
This function generates counts from a log-linear Poisson NAR(\eqn{p}) model, where \eqn{q} non time-varying covariates are allowed as well. The counts are simulated from \eqn{Y_{t}=N_{t}(e^{\nu_{t}})}, where \eqn{N_{t}} is a sequence of \eqn{N}-dimensional IID Poisson count processes, with intensity 1, and whose structure of dependence is modelled through a copula construction \eqn{C(\rho)} on their associated exponential waiting times random variables. For details see Armillotta and Fokianos (2024, Sec. 2.1-2.2).

The sequence \eqn{\nu_{t}} is the log of the expecation of \eqn{Y_{t}}, conditional to its past values and it is generated by means of the following log-PNAR(\eqn{p}) model. For each node of the network \eqn{i=1,...,N} over the time sample \eqn{t=1,...,TT}
\deqn{
\nu_{i,t}=\beta_{0}+\sum_{h=1}^{p}(\beta_{1h}X_{i,t-h}+\beta_{2h}Y_{i,t-h})+\sum_{l=1}^{q}\delta_{l}Z_{i,l}
}
where \eqn{X_{i,t}=\sum_{j=1}^{N}W_{ij}Y_{j,t}} is the network effect, i.e. the weighted average impact of node \eqn{i} connections, with the weights of the mean being \eqn{W_{ij}}, the single element of the network matrix \eqn{W}. The parameter \eqn{\beta_{0}} is the intercept of the model, \eqn{\beta_{1h}} are the network coefficients, \eqn{\beta_{2h}} are the autoregressive parameters, and \eqn{\delta_{l}} are the coefficients assocciated to the covariates \eqn{Z_{i,l}}.
}

\value{
A list including:
\item{p2R}{
The Toeplitz correlation matrix, if employed in the copula or NULL else.
}
\item{log_lambda}{
A \eqn{TT \times N} time series object matrix of simulated Poisson log-means for \eqn{N}
time series over \eqn{TT}.
}
\item{y}{
A \eqn{TT \times N} time series object matrix of simulated counts for \eqn{N} time series
over \eqn{TT}.
}
}

\seealso{
\code{\link{poisson.MODpq}, \link{poisson.MODpq.nonlin},
\link{poisson.MODpq.stnar}, \link{poisson.MODpq.tnar}
}
}

\references{
Armillotta, M. and K. Fokianos (2023). Nonlinear network autoregression. \emph{Annals of Statistics}, 51(6): 2526--2552.

Armillotta, M. and K. Fokianos (2024). Count network autoregression. \emph{Journal of Time Series Analysis}, 45(4): 584--612.

Armillotta, M., Tsagris, M. and Fokianos, K. (2024). Inference for Network Count Time Series with the R Package PNAR. \emph{The R Journal}, 15/4: 255--269.

Fokianos, K., Stove, B., Tjostheim, D., and P. Doukhan (2020).
Multivariate count autoregression. \emph{Bernoulli}, 26(1), 471--499.
}

\author{
Mirko Armillotta, Michail Tsagris and Konstantinos Fokianos.
}

\examples{
W <- adja( N = 20, K = 5, alpha= 0.5)
y <- poisson.MODpq.log( b = c(0.5, 0.3, 0.2), W = W, p = 1,
Z = NULL, TT = 1000, N = 20, copula = "gaussian",
corrtype = "equicorrelation", rho = 0.5)$y
}



