% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pns_deflator.R
\name{pns_deflator}
\alias{pns_deflator}
\title{Add deflator variables to PNS microdata}
\usage{
pns_deflator(data_pns, deflator.file)
}
\arguments{
\item{data_pns}{A tibble of PNS microdata read with \code{read_pns} function.}

\item{deflator.file}{The deflator file for selected survey available on official website: (select the deflator zip file) - \url{https://ftp.ibge.gov.br/PNS/Documentacao_Geral/}.}
}
\value{
A tibble with the data provided from PNS survey and the deflator variables added for use.
}
\description{
This function adds deflator variables to PNS microdata. For deflation of income variables, the documentation provided through the following address must be used: \url{https://ftp.ibge.gov.br/PNS/Documentacao_Geral/PNSIBGE_Deflator.pdf}.
}
\note{
For more information, visit the survey official website <\url{https://www.ibge.gov.br/estatisticas/sociais/saude/9160-pesquisa-nacional-de-saude.html?=&t=o-que-e}> and consult the other functions of this package, described below.
}
\examples{
# Using data read from disk
input_path <- pns_example(path="input_example.txt")
data_path <- pns_example(path="exampledata.txt")
dictionary.path <- pns_example(path="dictionaryexample.xls")
deflator.path <- pns_example(path="deflatorexample.xls")
pns.df <- read_pns(microdata=data_path, input_txt=input_path, vars=c("J007","J009"))
pns.df <- pns_labeller(data_pns=pns.df, dictionary.file=dictionary.path)
pns.df <- pns_deflator(data_pns=pns.df, deflator.file=deflator.path)
\donttest{
# Downloading data
pns.df2 <- get_pns(year=2019, selected=FALSE, anthropometry=FALSE, vars=c("J007","J009"),
                       labels=TRUE, deflator=FALSE, design=FALSE,
                       reload=TRUE, curlopts=list(), savedir=tempdir())
deflator.path2 <- pns_example(path="deflatorexample.xls")
pns.df2 <- pns_deflator(data_pns=pns.df2, deflator.file=deflator.path2)}
}
\seealso{
\link[PNSIBGE]{get_pns} for downloading, labeling, deflating and creating survey design object for PNS microdata.\cr \link[PNSIBGE]{read_pns} for reading PNS microdata.\cr \link[PNSIBGE]{pns_labeller} for labeling categorical variables from PNS microdata.\cr \link[PNSIBGE]{pns_design} for creating PNS survey design object.\cr \link[PNSIBGE]{pns_example} for getting the path of the PNS toy example files.
}
