% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/k_factor.R
\name{k_factor}
\alias{k_factor}
\title{Estimating K-factors for Tolerance Intervals Based on Howe's Method}
\usage{
k_factor(n, alpha = 0.05, P = 0.99, side = 1)
}
\arguments{
\item{n}{Sample size}

\item{alpha}{The level chosen such that (1-alpha) is the confidence level.}

\item{P}{The proportion of the population to be covered by the tolerance interval.}

\item{side}{Whether a 1-sided or 2-sided tolerance interval is required (determined by \code{side = 1} or \code{side = 2}, respectively).}
}
\value{
The estimated k-factor for tolerance intervals assuming normality.
}
\description{
Estimates k-factors for tolerance intervals based on Howe's method with normality assumption.
}
\note{
This function is a simplified version of \code{tolerance::K.factor()}, only considering Howe's method.
}
\examples{
k_factor(10, P = 0.95, side = 2)

}
\seealso{
\code{ti_pp}
}
